/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis;

import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.UnexpectedException;
import org.apache.skywalking.oap.server.core.analysis.ISourceDecorator;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceDecoratorManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceDecoratorManager.class);
    public static final Map<String, ISourceDecorator<ISource>> DECORATOR_MAP = new HashMap<String, ISourceDecorator<ISource>>();

    public void addIfAsSourceDecorator(Class<?> aClass) throws IllegalAccessException, InstantiationException {
        if (!aClass.isInterface() && !Modifier.isAbstract(aClass.getModifiers()) && ISourceDecorator.class.isAssignableFrom(aClass)) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = aClass.getGenericInterfaces()) {
                ParameterizedType anInterface = (ParameterizedType)genericInterface;
                if (!anInterface.getRawType().getTypeName().equals(ISourceDecorator.class.getName())) continue;
                Type[] arguments = anInterface.getActualTypeArguments();
                if (arguments.length != 1) {
                    throw new UnexpectedException("unexpected type argument number, class " + aClass.getName());
                }
                Type argument = arguments[0];
                Object source = ((Class)argument).newInstance();
                if (!ISource.class.isAssignableFrom(source.getClass())) {
                    throw new UnexpectedException("unexpected type argument of class " + aClass.getName() + ", should be `org.apache.skywalking.oap.server.core.source.Source`. ");
                }
                ISourceDecorator decorator = (ISourceDecorator)aClass.newInstance();
                ISourceDecorator<ISource> exist = DECORATOR_MAP.put(aClass.getSimpleName(), decorator);
                if (exist != null) {
                    throw new IllegalStateException("Conflict decorator names: The " + aClass.getName() + " class simple name is the same with " + exist.getClass().getName() + ", please change the class simple name.");
                }
                log.info("Decorator {} is added into DefaultScopeDefine {}.", (Object)decorator.getClass().getName(), (Object)((ISource)source).scope());
            }
        }
    }
}

