/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.networkalias;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.source.ScopeDeclaration;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@ScopeDeclaration(id=31, name="NetworkAddressAlias")
@Stream(name="network_address_alias", scopeId=31, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=true)
@BanyanDB.IndexMode
public class NetworkAddressAlias
extends Metrics {
    public static final String INDEX_NAME = "network_address_alias";
    public static final String ADDRESS = "address";
    public static final String REPRESENT_SERVICE_ID = "represent_service_id";
    public static final String REPRESENT_SERVICE_INSTANCE_ID = "represent_service_instance_id";
    public static final String LAST_UPDATE_TIME_BUCKET = "last_update_time_bucket";
    @Column(name="address")
    @BanyanDB.SeriesID(index=0)
    private String address;
    @Column(name="represent_service_id")
    @BanyanDB.SeriesID(index=1)
    private String representServiceId;
    @Column(name="represent_service_instance_id")
    @BanyanDB.SeriesID(index=2)
    private String representServiceInstanceId;
    @Column(name="last_update_time_bucket")
    private long lastUpdateTimeBucket;

    @Override
    public boolean combine(Metrics metrics) {
        NetworkAddressAlias alias = (NetworkAddressAlias)metrics;
        this.representServiceId = alias.getRepresentServiceId();
        this.representServiceInstanceId = alias.getRepresentServiceInstanceId();
        this.lastUpdateTimeBucket = alias.getLastUpdateTimeBucket();
        if (this.getTimeBucket() > metrics.getTimeBucket()) {
            this.setTimeBucket(metrics.getTimeBucket());
        }
        return true;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().appendMutant(new String[]{ADDRESS}, IDManager.NetworkAddressAliasDefine.buildId(this.address));
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setAddress(remoteData.getDataStrings(0));
        this.setRepresentServiceId(remoteData.getDataStrings(1));
        this.setRepresentServiceInstanceId(remoteData.getDataStrings(2));
        this.setLastUpdateTimeBucket(remoteData.getDataLongs(0));
        this.setTimeBucket(remoteData.getDataLongs(1));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.address);
        builder.addDataStrings(this.representServiceId);
        builder.addDataStrings(this.representServiceInstanceId);
        builder.addDataLongs(this.lastUpdateTimeBucket);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NetworkAddressAlias)) {
            return false;
        }
        NetworkAddressAlias other = (NetworkAddressAlias)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NetworkAddressAlias;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    @Generated
    public void setAddress(String address) {
        this.address = address;
    }

    @Generated
    public String getAddress() {
        return this.address;
    }

    @Generated
    public void setRepresentServiceId(String representServiceId) {
        this.representServiceId = representServiceId;
    }

    @Generated
    public String getRepresentServiceId() {
        return this.representServiceId;
    }

    @Generated
    public void setRepresentServiceInstanceId(String representServiceInstanceId) {
        this.representServiceInstanceId = representServiceInstanceId;
    }

    @Generated
    public String getRepresentServiceInstanceId() {
        return this.representServiceInstanceId;
    }

    @Generated
    public void setLastUpdateTimeBucket(long lastUpdateTimeBucket) {
        this.lastUpdateTimeBucket = lastUpdateTimeBucket;
    }

    @Generated
    public long getLastUpdateTimeBucket() {
        return this.lastUpdateTimeBucket;
    }

    public static class Builder
    implements StorageBuilder<NetworkAddressAlias> {
        @Override
        public NetworkAddressAlias storage2Entity(Convert2Entity converter) {
            NetworkAddressAlias networkAddressAlias = new NetworkAddressAlias();
            networkAddressAlias.setAddress((String)converter.get(NetworkAddressAlias.ADDRESS));
            networkAddressAlias.setRepresentServiceId((String)converter.get(NetworkAddressAlias.REPRESENT_SERVICE_ID));
            networkAddressAlias.setRepresentServiceInstanceId((String)converter.get(NetworkAddressAlias.REPRESENT_SERVICE_INSTANCE_ID));
            networkAddressAlias.setLastUpdateTimeBucket(((Number)converter.get(NetworkAddressAlias.LAST_UPDATE_TIME_BUCKET)).longValue());
            networkAddressAlias.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return networkAddressAlias;
        }

        @Override
        public void entity2Storage(NetworkAddressAlias storageData, Convert2Storage converter) {
            converter.accept(NetworkAddressAlias.ADDRESS, storageData.getAddress());
            converter.accept(NetworkAddressAlias.REPRESENT_SERVICE_ID, storageData.getRepresentServiceId());
            converter.accept(NetworkAddressAlias.REPRESENT_SERVICE_INSTANCE_ID, storageData.getRepresentServiceInstanceId());
            converter.accept(NetworkAddressAlias.LAST_UPDATE_TIME_BUCKET, storageData.getLastUpdateTimeBucket());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

