/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.analysis.manual.searchtag;

import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.MetricsExtension;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.metrics.Metrics;
import org.apache.skywalking.oap.server.core.analysis.worker.MetricsStreamProcessor;
import org.apache.skywalking.oap.server.core.remote.grpc.proto.RemoteData;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.annotation.ElasticSearch;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="tag_autocomplete", scopeId=50, builder=Builder.class, processor=MetricsStreamProcessor.class)
@MetricsExtension(supportDownSampling=false, supportUpdate=false, timeRelativeID=false)
@BanyanDB.IndexMode
public class TagAutocompleteData
extends Metrics {
    public static final String INDEX_NAME = "tag_autocomplete";
    public static final String TAG_KEY = "tag_key";
    public static final String TAG_VALUE = "tag_value";
    public static final String TAG_TYPE = "tag_type";
    @Column(name="tag_key")
    @ElasticSearch.EnableDocValues
    @BanyanDB.SeriesID(index=1)
    private String tagKey;
    @Column(name="tag_value", length=256)
    @BanyanDB.SeriesID(index=2)
    private String tagValue;
    @Column(name="tag_type")
    @BanyanDB.SeriesID(index=0)
    private String tagType;

    @Override
    public boolean combine(Metrics metrics) {
        return true;
    }

    @Override
    public void calculate() {
    }

    @Override
    public Metrics toHour() {
        return null;
    }

    @Override
    public Metrics toDay() {
        return null;
    }

    @Override
    protected StorageID id0() {
        return new StorageID().appendMutant(new String[]{"time_bucket"}, this.toTimeBucketInDay()).append(TAG_TYPE, this.tagType).append(TAG_KEY, this.tagKey).append(TAG_VALUE, this.tagValue);
    }

    @Override
    public int remoteHashCode() {
        return this.hashCode();
    }

    @Override
    public void deserialize(RemoteData remoteData) {
        this.setTagKey(remoteData.getDataStrings(0));
        this.setTagValue(remoteData.getDataStrings(1));
        this.setTagType(remoteData.getDataStrings(2));
        this.setTimeBucket(remoteData.getDataLongs(0));
    }

    @Override
    public RemoteData.Builder serialize() {
        RemoteData.Builder builder = RemoteData.newBuilder();
        builder.addDataStrings(this.tagKey);
        builder.addDataStrings(this.tagValue);
        builder.addDataStrings(this.tagType);
        builder.addDataLongs(this.getTimeBucket());
        return builder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagAutocompleteData)) {
            return false;
        }
        TagAutocompleteData other = (TagAutocompleteData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tagKey = this.getTagKey();
        String other$tagKey = other.getTagKey();
        if (this$tagKey == null ? other$tagKey != null : !this$tagKey.equals(other$tagKey)) {
            return false;
        }
        String this$tagValue = this.getTagValue();
        String other$tagValue = other.getTagValue();
        if (this$tagValue == null ? other$tagValue != null : !this$tagValue.equals(other$tagValue)) {
            return false;
        }
        String this$tagType = this.getTagType();
        String other$tagType = other.getTagType();
        return !(this$tagType == null ? other$tagType != null : !this$tagType.equals(other$tagType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TagAutocompleteData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tagKey = this.getTagKey();
        result = result * 59 + ($tagKey == null ? 43 : $tagKey.hashCode());
        String $tagValue = this.getTagValue();
        result = result * 59 + ($tagValue == null ? 43 : $tagValue.hashCode());
        String $tagType = this.getTagType();
        result = result * 59 + ($tagType == null ? 43 : $tagType.hashCode());
        return result;
    }

    @Generated
    public void setTagKey(String tagKey) {
        this.tagKey = tagKey;
    }

    @Generated
    public String getTagKey() {
        return this.tagKey;
    }

    @Generated
    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    @Generated
    public String getTagValue() {
        return this.tagValue;
    }

    @Generated
    public void setTagType(String tagType) {
        this.tagType = tagType;
    }

    @Generated
    public String getTagType() {
        return this.tagType;
    }

    public static class Builder
    implements StorageBuilder<TagAutocompleteData> {
        @Override
        public TagAutocompleteData storage2Entity(Convert2Entity converter) {
            TagAutocompleteData record = new TagAutocompleteData();
            record.setTagKey((String)converter.get(TagAutocompleteData.TAG_KEY));
            record.setTagValue((String)converter.get(TagAutocompleteData.TAG_VALUE));
            record.setTagType((String)converter.get(TagAutocompleteData.TAG_TYPE));
            record.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return record;
        }

        @Override
        public void entity2Storage(TagAutocompleteData storageData, Convert2Storage converter) {
            converter.accept(TagAutocompleteData.TAG_KEY, storageData.getTagKey());
            converter.accept(TagAutocompleteData.TAG_VALUE, storageData.getTagValue());
            converter.accept(TagAutocompleteData.TAG_TYPE, storageData.getTagType());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

