/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.core.profiling.ebpf.storage;

import com.google.common.base.Charsets;
import com.google.common.hash.Hashing;
import java.util.Arrays;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.Stream;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.core.storage.StorageID;
import org.apache.skywalking.oap.server.core.storage.annotation.BanyanDB;
import org.apache.skywalking.oap.server.core.storage.annotation.Column;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Entity;
import org.apache.skywalking.oap.server.core.storage.type.Convert2Storage;
import org.apache.skywalking.oap.server.core.storage.type.StorageBuilder;

@Stream(name="ebpf_profiling_data", scopeId=48, builder=Builder.class, processor=RecordStreamProcessor.class)
@BanyanDB.TimestampColumn(value="upload_time")
public class EBPFProfilingDataRecord
extends Record {
    public static final String INDEX_NAME = "ebpf_profiling_data";
    public static final String SCHEDULE_ID = "schedule_id";
    public static final String TASK_ID = "task_id";
    public static final String STACK_ID_LIST = "stack_id";
    public static final String TARGET_TYPE = "target_type";
    public static final String DATA_BINARY = "dump_binary";
    public static final String UPLOAD_TIME = "upload_time";
    @Column(name="task_id")
    private String taskId;
    @BanyanDB.SeriesID(index=0)
    @Column(name="schedule_id")
    private String scheduleId;
    @Column(name="stack_id")
    private String stackIdList;
    @Column(name="target_type")
    private int targetType;
    @Column(name="dump_binary", storageOnly=true)
    private byte[] dataBinary;
    @Column(name="upload_time")
    private long uploadTime;

    @Override
    public StorageID id() {
        return new StorageID().appendMutant(new String[]{SCHEDULE_ID, STACK_ID_LIST, UPLOAD_TIME}, Hashing.sha256().newHasher().putString((CharSequence)this.scheduleId, Charsets.UTF_8).putString((CharSequence)this.stackIdList, Charsets.UTF_8).putLong(this.uploadTime).hash().toString());
    }

    @Generated
    public EBPFProfilingDataRecord() {
    }

    @Generated
    public String getTaskId() {
        return this.taskId;
    }

    @Generated
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Generated
    public String getStackIdList() {
        return this.stackIdList;
    }

    @Generated
    public int getTargetType() {
        return this.targetType;
    }

    @Generated
    public byte[] getDataBinary() {
        return this.dataBinary;
    }

    @Generated
    public long getUploadTime() {
        return this.uploadTime;
    }

    @Generated
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    @Generated
    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    @Generated
    public void setStackIdList(String stackIdList) {
        this.stackIdList = stackIdList;
    }

    @Generated
    public void setTargetType(int targetType) {
        this.targetType = targetType;
    }

    @Generated
    public void setDataBinary(byte[] dataBinary) {
        this.dataBinary = dataBinary;
    }

    @Generated
    public void setUploadTime(long uploadTime) {
        this.uploadTime = uploadTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EBPFProfilingDataRecord)) {
            return false;
        }
        EBPFProfilingDataRecord other = (EBPFProfilingDataRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTargetType() != other.getTargetType()) {
            return false;
        }
        if (this.getUploadTime() != other.getUploadTime()) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        String this$scheduleId = this.getScheduleId();
        String other$scheduleId = other.getScheduleId();
        if (this$scheduleId == null ? other$scheduleId != null : !this$scheduleId.equals(other$scheduleId)) {
            return false;
        }
        String this$stackIdList = this.getStackIdList();
        String other$stackIdList = other.getStackIdList();
        if (this$stackIdList == null ? other$stackIdList != null : !this$stackIdList.equals(other$stackIdList)) {
            return false;
        }
        return Arrays.equals(this.getDataBinary(), other.getDataBinary());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EBPFProfilingDataRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTargetType();
        long $uploadTime = this.getUploadTime();
        result = result * 59 + (int)($uploadTime >>> 32 ^ $uploadTime);
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        String $scheduleId = this.getScheduleId();
        result = result * 59 + ($scheduleId == null ? 43 : $scheduleId.hashCode());
        String $stackIdList = this.getStackIdList();
        result = result * 59 + ($stackIdList == null ? 43 : $stackIdList.hashCode());
        result = result * 59 + Arrays.hashCode(this.getDataBinary());
        return result;
    }

    @Generated
    public String toString() {
        return "EBPFProfilingDataRecord(taskId=" + this.getTaskId() + ", scheduleId=" + this.getScheduleId() + ", stackIdList=" + this.getStackIdList() + ", targetType=" + this.getTargetType() + ", dataBinary=" + Arrays.toString(this.getDataBinary()) + ", uploadTime=" + this.getUploadTime() + ")";
    }

    public static class Builder
    implements StorageBuilder<EBPFProfilingDataRecord> {
        @Override
        public EBPFProfilingDataRecord storage2Entity(Convert2Entity converter) {
            EBPFProfilingDataRecord dataTraffic = new EBPFProfilingDataRecord();
            dataTraffic.setScheduleId((String)converter.get(EBPFProfilingDataRecord.SCHEDULE_ID));
            dataTraffic.setTaskId((String)converter.get(EBPFProfilingDataRecord.TASK_ID));
            dataTraffic.setStackIdList((String)converter.get(EBPFProfilingDataRecord.STACK_ID_LIST));
            dataTraffic.setTargetType(((Number)converter.get(EBPFProfilingDataRecord.TARGET_TYPE)).intValue());
            dataTraffic.setDataBinary(converter.getBytes(EBPFProfilingDataRecord.DATA_BINARY));
            dataTraffic.setUploadTime(((Number)converter.get(EBPFProfilingDataRecord.UPLOAD_TIME)).longValue());
            dataTraffic.setTimeBucket(((Number)converter.get("time_bucket")).longValue());
            return dataTraffic;
        }

        @Override
        public void entity2Storage(EBPFProfilingDataRecord storageData, Convert2Storage converter) {
            converter.accept(EBPFProfilingDataRecord.SCHEDULE_ID, storageData.getScheduleId());
            converter.accept(EBPFProfilingDataRecord.TASK_ID, storageData.getTaskId());
            converter.accept(EBPFProfilingDataRecord.STACK_ID_LIST, storageData.getStackIdList());
            converter.accept(EBPFProfilingDataRecord.TARGET_TYPE, storageData.getTargetType());
            converter.accept(EBPFProfilingDataRecord.DATA_BINARY, storageData.getDataBinary());
            converter.accept(EBPFProfilingDataRecord.UPLOAD_TIME, storageData.getUploadTime());
            converter.accept("time_bucket", storageData.getTimeBucket());
        }
    }
}

