/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.grpc;

import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.GrpcClientBuilder;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import java.net.URI;
import java.util.Objects;

@UnstableApi
public final class GrpcClients {
    public static <T> T newClient(String uri, Class<T> clientType) {
        return GrpcClients.builder(uri).build(clientType);
    }

    public static <T> T newClient(URI uri, Class<T> clientType) {
        return GrpcClients.builder(uri).build(clientType);
    }

    public static <T> T newClient(String scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return GrpcClients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(Scheme scheme, EndpointGroup endpointGroup, Class<T> clientType) {
        return GrpcClients.builder(scheme, endpointGroup).build(clientType);
    }

    public static <T> T newClient(SessionProtocol protocol, EndpointGroup endpointGroup, Class<T> clientType) {
        return GrpcClients.builder(protocol, endpointGroup).build(clientType);
    }

    public static GrpcClientBuilder builder(String uri) {
        return GrpcClients.builder(URI.create(Objects.requireNonNull(uri, "uri")));
    }

    public static GrpcClientBuilder builder(URI uri) {
        return new GrpcClientBuilder(Objects.requireNonNull(uri, "uri"));
    }

    public static GrpcClientBuilder builder(String scheme, EndpointGroup endpointGroup) {
        return GrpcClients.builder(Scheme.parse((String)Objects.requireNonNull(scheme, "scheme")), endpointGroup);
    }

    public static GrpcClientBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return GrpcClients.builder(Scheme.of((SerializationFormat)GrpcSerializationFormats.PROTO, (SessionProtocol)Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static GrpcClientBuilder builder(Scheme scheme, EndpointGroup endpointGroup) {
        Objects.requireNonNull(scheme, "scheme");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return new GrpcClientBuilder(scheme, endpointGroup);
    }

    private GrpcClients() {
    }
}

