/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.util.function;

import com.ctrip.framework.apollo.exceptions.ApolloConfigException;
import com.ctrip.framework.apollo.util.parser.ParserException;
import com.ctrip.framework.apollo.util.parser.Parsers;
import com.google.common.base.Function;
import java.util.Date;

public interface Functions {
    public static final Function<String, Integer> TO_INT_FUNCTION = new Function<String, Integer>(){

        public Integer apply(String input) {
            return Integer.parseInt(input);
        }
    };
    public static final Function<String, Long> TO_LONG_FUNCTION = new Function<String, Long>(){

        public Long apply(String input) {
            return Long.parseLong(input);
        }
    };
    public static final Function<String, Short> TO_SHORT_FUNCTION = new Function<String, Short>(){

        public Short apply(String input) {
            return Short.parseShort(input);
        }
    };
    public static final Function<String, Float> TO_FLOAT_FUNCTION = new Function<String, Float>(){

        public Float apply(String input) {
            return Float.valueOf(Float.parseFloat(input));
        }
    };
    public static final Function<String, Double> TO_DOUBLE_FUNCTION = new Function<String, Double>(){

        public Double apply(String input) {
            return Double.parseDouble(input);
        }
    };
    public static final Function<String, Byte> TO_BYTE_FUNCTION = new Function<String, Byte>(){

        public Byte apply(String input) {
            return Byte.parseByte(input);
        }
    };
    public static final Function<String, Boolean> TO_BOOLEAN_FUNCTION = new Function<String, Boolean>(){

        public Boolean apply(String input) {
            return Boolean.parseBoolean(input);
        }
    };
    public static final Function<String, Date> TO_DATE_FUNCTION = new Function<String, Date>(){

        public Date apply(String input) {
            try {
                return Parsers.forDate().parse(input);
            }
            catch (ParserException ex) {
                throw new ApolloConfigException("Parse date failed", ex);
            }
        }
    };
    public static final Function<String, Long> TO_DURATION_FUNCTION = new Function<String, Long>(){

        public Long apply(String input) {
            try {
                return Parsers.forDuration().parseToMillis(input);
            }
            catch (ParserException ex) {
                throw new ApolloConfigException("Parse duration failed", ex);
            }
        }
    };
}

