/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.client.Http2ClientConnectionHandler;
import com.linecorp.armeria.client.HttpClientFactory;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.common.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.channel.Channel;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;

final class Http2ClientConnectionHandlerBuilder
extends AbstractHttp2ConnectionHandlerBuilder<Http2ClientConnectionHandler, Http2ClientConnectionHandlerBuilder> {
    private final HttpClientFactory clientFactory;
    private final SessionProtocol protocol;

    Http2ClientConnectionHandlerBuilder(Channel ch, HttpClientFactory clientFactory, SessionProtocol protocol) {
        super(ch);
        this.clientFactory = clientFactory;
        this.protocol = protocol;
        this.decoderEnforceMaxRstFramesPerWindow(0, 0);
        long gracefulShutdownTimeoutMillis = clientFactory.http2GracefulShutdownTimeoutMillis();
        if (gracefulShutdownTimeoutMillis == Long.MAX_VALUE) {
            this.gracefulShutdownTimeoutMillis(-1L);
        } else {
            this.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
        }
    }

    protected Http2ClientConnectionHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
        return new Http2ClientConnectionHandler(decoder, encoder, initialSettings, this.channel(), this.clientFactory, this.protocol);
    }
}

