/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.annotation.UnstableApi;

@UnstableApi
public enum ExchangeType {
    UNARY(false, false),
    REQUEST_STREAMING(true, false),
    RESPONSE_STREAMING(false, true),
    BIDI_STREAMING(true, true);

    private final boolean requestStreaming;
    private final boolean responseStreaming;

    public static ExchangeType of(boolean requestStreaming, boolean responseStreaming) {
        if (requestStreaming) {
            return responseStreaming ? BIDI_STREAMING : REQUEST_STREAMING;
        }
        return responseStreaming ? RESPONSE_STREAMING : UNARY;
    }

    private ExchangeType(boolean requestStreaming, boolean responseStreaming) {
        this.requestStreaming = requestStreaming;
        this.responseStreaming = responseStreaming;
    }

    public boolean isRequestStreaming() {
        return this.requestStreaming;
    }

    public boolean isResponseStreaming() {
        return this.responseStreaming;
    }
}

