/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms;

import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.Composer;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import com.linecorp.armeria.internal.shaded.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HSSPublicKeyParameters
extends LMSKeyParameters {
    private final int l;
    private final LMSPublicKeyParameters lmsPublicKey;

    public HSSPublicKeyParameters(int n, LMSPublicKeyParameters lMSPublicKeyParameters) {
        super(false);
        this.l = n;
        this.lmsPublicKey = lMSPublicKeyParameters;
    }

    public static HSSPublicKeyParameters getInstance(Object object) throws IOException {
        if (object instanceof HSSPublicKeyParameters) {
            return (HSSPublicKeyParameters)object;
        }
        if (object instanceof DataInputStream) {
            int n = ((DataInputStream)object).readInt();
            LMSPublicKeyParameters lMSPublicKeyParameters = LMSPublicKeyParameters.getInstance(object);
            return new HSSPublicKeyParameters(n, lMSPublicKeyParameters);
        }
        if (object instanceof byte[]) {
            InputStream inputStream = null;
            try {
                inputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                HSSPublicKeyParameters hSSPublicKeyParameters = HSSPublicKeyParameters.getInstance(inputStream);
                return hSSPublicKeyParameters;
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        if (object instanceof InputStream) {
            return HSSPublicKeyParameters.getInstance(Streams.readAll((InputStream)object));
        }
        throw new IllegalArgumentException("cannot parse " + object);
    }

    public int getL() {
        return this.l;
    }

    public LMSPublicKeyParameters getLMSPublicKey() {
        return this.lmsPublicKey;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HSSPublicKeyParameters hSSPublicKeyParameters = (HSSPublicKeyParameters)object;
        if (this.l != hSSPublicKeyParameters.l) {
            return false;
        }
        return this.lmsPublicKey.equals(hSSPublicKeyParameters.lmsPublicKey);
    }

    public int hashCode() {
        int n = this.l;
        n = 31 * n + this.lmsPublicKey.hashCode();
        return n;
    }

    public byte[] getEncoded() throws IOException {
        return Composer.compose().u32str(this.l).bytes(this.lmsPublicKey.getEncoded()).build();
    }
}

