/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.bouncycastle.util;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class Pack {
    public static int bigEndianToInt(byte[] byArray, int n) {
        int n2 = byArray[n] << 24;
        n2 |= (byArray[++n] & 0xFF) << 16;
        n2 |= (byArray[++n] & 0xFF) << 8;
        return n2 |= byArray[++n] & 0xFF;
    }

    public static byte[] intToBigEndian(int n) {
        byte[] byArray = new byte[4];
        Pack.intToBigEndian(n, byArray, 0);
        return byArray;
    }

    public static void intToBigEndian(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n >>> 24);
        byArray[++n2] = (byte)(n >>> 16);
        byArray[++n2] = (byte)(n >>> 8);
        byArray[++n2] = (byte)n;
    }

    public static void intToBigEndian(int[] nArray, byte[] byArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            Pack.intToBigEndian(nArray[i], byArray, n);
            n += 4;
        }
    }

    public static long bigEndianToLong(byte[] byArray, int n) {
        int n2 = Pack.bigEndianToInt(byArray, n);
        int n3 = Pack.bigEndianToInt(byArray, n + 4);
        return ((long)n2 & 0xFFFFFFFFL) << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    public static void longToBigEndian(long l, byte[] byArray, int n) {
        Pack.intToBigEndian((int)(l >>> 32), byArray, n);
        Pack.intToBigEndian((int)(l & 0xFFFFFFFFL), byArray, n + 4);
    }

    public static short littleEndianToShort(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        return (short)(n2 |= (byArray[++n] & 0xFF) << 8);
    }

    public static int littleEndianToInt(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        n2 |= (byArray[++n] & 0xFF) << 8;
        n2 |= (byArray[++n] & 0xFF) << 16;
        return n2 |= byArray[++n] << 24;
    }

    public static void littleEndianToInt(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = Pack.littleEndianToInt(byArray, n);
            n += 4;
        }
    }

    public static void shortToLittleEndian(short s, byte[] byArray, int n) {
        byArray[n] = (byte)s;
        byArray[++n] = (byte)(s >>> 8);
    }

    public static void shortToBigEndian(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s >>> 8);
        byArray[++n] = (byte)s;
    }

    public static byte[] intToLittleEndian(int n) {
        byte[] byArray = new byte[4];
        Pack.intToLittleEndian(n, byArray, 0);
        return byArray;
    }

    public static void intToLittleEndian(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)n;
        byArray[++n2] = (byte)(n >>> 8);
        byArray[++n2] = (byte)(n >>> 16);
        byArray[++n2] = (byte)(n >>> 24);
    }

    public static long littleEndianToLong(byte[] byArray, int n) {
        int n2 = Pack.littleEndianToInt(byArray, n);
        int n3 = Pack.littleEndianToInt(byArray, n + 4);
        return ((long)n3 & 0xFFFFFFFFL) << 32 | (long)n2 & 0xFFFFFFFFL;
    }

    public static byte[] longToLittleEndian(long l) {
        byte[] byArray = new byte[8];
        Pack.longToLittleEndian(l, byArray, 0);
        return byArray;
    }

    public static void longToLittleEndian(long l, byte[] byArray, int n) {
        Pack.intToLittleEndian((int)(l & 0xFFFFFFFFL), byArray, n);
        Pack.intToLittleEndian((int)(l >>> 32), byArray, n + 4);
    }

    public static void longToLittleEndian(long[] lArray, int n, int n2, byte[] byArray, int n3) {
        for (int i = 0; i < n2; ++i) {
            Pack.longToLittleEndian(lArray[n + i], byArray, n3);
            n3 += 8;
        }
    }
}

