/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.streaming;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.server.ResponseConversionUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonLines {
    private static final Logger logger = LoggerFactory.getLogger(JsonLines.class);
    private static boolean warnedStatusCode;
    private static boolean warnedContentType;
    private static final byte LINE_FEED = 10;
    private static final ObjectMapper defaultMapper;
    private static final ResponseHeaders defaultHttpHeaders;

    public static HttpResponse fromPublisher(Publisher<?> contentPublisher) {
        return JsonLines.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromPublisher(Publisher<?> contentPublisher, ObjectMapper mapper) {
        return JsonLines.fromPublisher(defaultHttpHeaders, contentPublisher, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher) {
        return JsonLines.fromPublisher(headers, contentPublisher, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher, ObjectMapper mapper) {
        return JsonLines.fromPublisher(headers, contentPublisher, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromPublisher(ResponseHeaders headers, Publisher<?> contentPublisher, HttpHeaders trailers, ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return ResponseConversionUtil.streamingFrom(contentPublisher, JsonLines.sanitizeHeaders(headers), trailers, o -> JsonLines.toHttpData(mapper, o));
    }

    static <T> HttpResponse fromPublisher(ResponseHeaders headers, Publisher<T> contentPublisher, HttpHeaders trailers, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(contentConverter, "contentConverter");
        return ResponseConversionUtil.streamingFrom(contentPublisher, JsonLines.sanitizeHeaders(headers), trailers, o -> JsonLines.toHttpData(contentConverter, o));
    }

    public static HttpResponse fromStream(Stream<?> contentStream, Executor executor) {
        return JsonLines.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor, defaultMapper);
    }

    public static HttpResponse fromStream(Stream<?> contentStream, Executor executor, ObjectMapper mapper) {
        return JsonLines.fromStream(defaultHttpHeaders, contentStream, HttpHeaders.of(), executor, mapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, Executor executor) {
        return JsonLines.fromStream(headers, contentStream, HttpHeaders.of(), executor, defaultMapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, Executor executor, ObjectMapper mapper) {
        return JsonLines.fromStream(headers, contentStream, HttpHeaders.of(), executor, mapper);
    }

    public static HttpResponse fromStream(ResponseHeaders headers, Stream<?> contentStream, HttpHeaders trailers, Executor executor, ObjectMapper mapper) {
        Objects.requireNonNull(mapper, "mapper");
        return ResponseConversionUtil.streamingFrom(contentStream, JsonLines.sanitizeHeaders(headers), trailers, o -> JsonLines.toHttpData(mapper, o), executor);
    }

    static <T> HttpResponse fromStream(ResponseHeaders headers, Stream<T> contentStream, HttpHeaders trailers, Executor executor, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(contentConverter, "contentConverter");
        return ResponseConversionUtil.streamingFrom(contentStream, JsonLines.sanitizeHeaders(headers), trailers, o -> JsonLines.toHttpData(contentConverter, o), executor);
    }

    public static HttpResponse fromObject(@Nullable Object content) {
        return JsonLines.fromObject(defaultHttpHeaders, content, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content) {
        return JsonLines.fromObject(headers, content, HttpHeaders.of(), defaultMapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content, ObjectMapper mapper) {
        return JsonLines.fromObject(headers, content, HttpHeaders.of(), mapper);
    }

    public static HttpResponse fromObject(ResponseHeaders headers, @Nullable Object content, HttpHeaders trailers, ObjectMapper mapper) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(mapper, "mapper");
        return HttpResponse.of(JsonLines.sanitizeHeaders(headers), JsonLines.toHttpData(mapper, content), trailers);
    }

    static <T> HttpResponse fromObject(ResponseHeaders headers, @Nullable T content, HttpHeaders trailers, Function<? super T, String> contentConverter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(trailers, "trailers");
        Objects.requireNonNull(contentConverter, "contentConverter");
        return HttpResponse.of(JsonLines.sanitizeHeaders(headers), JsonLines.toHttpData(contentConverter, content), trailers);
    }

    private static ResponseHeaders sanitizeHeaders(ResponseHeaders headers) {
        Objects.requireNonNull(headers, "headers");
        if (headers == defaultHttpHeaders) {
            return headers;
        }
        return JsonLines.ensureContentType(JsonLines.ensureHttpStatus(headers));
    }

    static ResponseHeaders ensureHttpStatus(ResponseHeaders headers) {
        HttpStatus status = headers.status();
        if (status == HttpStatus.OK) {
            return headers;
        }
        if (!warnedStatusCode) {
            logger.warn("Overwriting the HTTP status code from '{}' to '{}' for JSON Lines. Do not set an HTTP status code on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its status code. Please refer to https://jsonlines.org/ for more information.", new Object[]{status, HttpStatus.OK, JsonLines.class.getSimpleName(), HttpStatus.OK});
            warnedStatusCode = true;
        }
        return headers.toBuilder().status(HttpStatus.OK).build();
    }

    static ResponseHeaders ensureContentType(ResponseHeaders headers) {
        MediaType contentType = headers.contentType();
        if (contentType == null) {
            return headers.toBuilder().contentType(MediaType.JSON_LINES).build();
        }
        if (contentType.is(MediaType.JSON_LINES)) {
            return headers;
        }
        if (!warnedContentType) {
            logger.warn("Overwriting content-type from '{}' to '{}' for JSON Lines. Do not set a content-type on the HttpHeaders when calling factory methods in '{}', or set '{}' if you want to specify its content-type. Please refer to https://jsonlines.org/ for more information.", new Object[]{contentType, MediaType.JSON_LINES, JsonLines.class.getSimpleName(), MediaType.JSON_LINES});
            warnedContentType = true;
        }
        return headers.toBuilder().contentType(MediaType.JSON_LINES).build();
    }

    private static HttpData toHttpData(ObjectMapper mapper, @Nullable Object value) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            if (mapper == defaultMapper) {
                mapper.writeValue((OutputStream)out, value);
            } else {
                JsonNode root = mapper.valueToTree(value);
                defaultMapper.writeValue((OutputStream)out, (Object)root);
            }
            out.write(10);
            return HttpData.wrap(out.toByteArray());
        }
        catch (Exception e) {
            return (HttpData)Exceptions.throwUnsafely(e);
        }
    }

    private static <T> HttpData toHttpData(Function<? super T, String> contentConverter, @Nullable T value) {
        String content = contentConverter.apply(value);
        Objects.requireNonNull(content, "contentConverter.apply() returned null");
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        int contentLength = contentBytes.length;
        byte[] jsonText = new byte[contentLength + 1];
        System.arraycopy(contentBytes, 0, jsonText, 1, contentLength);
        jsonText[contentLength + 1] = 10;
        return HttpData.wrap(jsonText);
    }

    private JsonLines() {
    }

    static {
        defaultMapper = JacksonUtil.newDefaultObjectMapper().disable(SerializationFeature.INDENT_OUTPUT);
        defaultHttpHeaders = ResponseHeaders.builder(HttpStatus.OK).contentType(MediaType.JSON_LINES).build();
    }
}

