/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ClaimSource;
import io.fabric8.kubernetes.api.model.ClaimSourceFluent;
import io.fabric8.kubernetes.api.model.ClaimSourceFluentImpl;

public class ClaimSourceBuilder
extends ClaimSourceFluentImpl<ClaimSourceBuilder>
implements VisitableBuilder<ClaimSource, ClaimSourceBuilder> {
    ClaimSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ClaimSourceBuilder() {
        this(false);
    }

    public ClaimSourceBuilder(Boolean validationEnabled) {
        this(new ClaimSource(), validationEnabled);
    }

    public ClaimSourceBuilder(ClaimSourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ClaimSourceBuilder(ClaimSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClaimSource(), validationEnabled);
    }

    public ClaimSourceBuilder(ClaimSourceFluent<?> fluent, ClaimSource instance) {
        this(fluent, instance, false);
    }

    public ClaimSourceBuilder(ClaimSourceFluent<?> fluent, ClaimSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withResourceClaimName(instance.getResourceClaimName());
            fluent.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ClaimSourceBuilder(ClaimSource instance) {
        this(instance, (Boolean)false);
    }

    public ClaimSourceBuilder(ClaimSource instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withResourceClaimName(instance.getResourceClaimName());
            this.withResourceClaimTemplateName(instance.getResourceClaimTemplateName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClaimSource build() {
        ClaimSource buildable = new ClaimSource(this.fluent.getResourceClaimName(), this.fluent.getResourceClaimTemplateName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

