/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.ai.pipeline.services;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineMetricPrediction;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineMetricsNames;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineRequest;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineResponse;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineServiceGrpc;
import org.apache.skywalking.apm.baseline.v3.AlarmBaselineServiceMetricName;
import org.apache.skywalking.apm.baseline.v3.KeyStringValuePair;
import org.apache.skywalking.apm.baseline.v3.TimeBucketStep;
import org.apache.skywalking.oap.server.ai.pipeline.services.BaselineQueryService;
import org.apache.skywalking.oap.server.ai.pipeline.services.PredictServiceMetrics;
import org.apache.skywalking.oap.server.ai.pipeline.services.ServiceMetrics;
import org.apache.skywalking.oap.server.core.analysis.DownSampling;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.library.client.grpc.GRPCClient;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaselineQueryServiceImpl
implements BaselineQueryService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaselineQueryServiceImpl.class);
    private AlarmBaselineServiceGrpc.AlarmBaselineServiceBlockingStub stub;
    private final Cache<String, Map<String, PredictServiceMetrics.PredictMetricsValue>> baselineCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).build();

    public BaselineQueryServiceImpl(String addr, int port) {
        if (StringUtil.isEmpty((String)addr) || port <= 0) {
            return;
        }
        GRPCClient client = new GRPCClient(addr, port);
        client.connect();
        ManagedChannel channel = client.getChannel();
        this.stub = AlarmBaselineServiceGrpc.newBlockingStub((Channel)channel);
    }

    @Override
    public List<String> querySupportedMetrics() {
        if (this.stub == null) {
            log.warn("Baseline service is not set up, return empty list.");
            return Collections.emptyList();
        }
        AlarmBaselineMetricsNames names = this.stub.querySupportedMetricsNames(Empty.newBuilder().build());
        return Optional.ofNullable(names).map(AlarmBaselineMetricsNames::getMetricNamesList).map(ArrayList::new).orElse(new ArrayList(0));
    }

    @Override
    public List<PredictServiceMetrics> queryPredictMetrics(List<ServiceMetrics> serviceMetrics, long startTimeBucket, long endTimeBucket) {
        if (this.stub == null) {
            log.warn("Baseline service is not set up, return empty baseline values.");
            return Collections.emptyList();
        }
        try {
            return this.queryPredictMetrics0(serviceMetrics, startTimeBucket, endTimeBucket);
        }
        catch (Exception e) {
            log.warn("Query baseline failure", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Map<String, PredictServiceMetrics.PredictMetricsValue> queryPredictMetricsFromCache(String serviceName, String timeBucketHour) {
        if (this.stub == null) {
            log.warn("Baseline service is not set up, return empty baseline values.");
            return Collections.emptyMap();
        }
        String key = timeBucketHour + "," + serviceName;
        Map baselineValues = (Map)this.baselineCache.asMap().get(key);
        if (CollectionUtils.isNotEmpty((Map)baselineValues)) {
            return baselineValues;
        }
        List<String> metrics = this.querySupportedMetrics();
        ServiceMetrics serviceMetrics = ServiceMetrics.builder().serviceName(serviceName).metricsNames(metrics).build();
        long startTimeBucket = TimeBucket.getTimeBucket((long)(System.currentTimeMillis() - TimeUnit.HOURS.toMillis(24L)), (DownSampling)DownSampling.Hour);
        long endTimeBucket = TimeBucket.getTimeBucket((long)(System.currentTimeMillis() + TimeUnit.HOURS.toMillis(24L)), (DownSampling)DownSampling.Hour);
        List<PredictServiceMetrics> predictServiceMetricsList = this.queryPredictMetrics(Collections.singletonList(serviceMetrics), startTimeBucket, endTimeBucket);
        if (CollectionUtils.isEmpty(predictServiceMetricsList)) {
            return Collections.emptyMap();
        }
        for (String metricName : metrics) {
            for (PredictServiceMetrics predictServiceMetrics : predictServiceMetricsList) {
                List<PredictServiceMetrics.PredictMetricsValue> predictMetricsValues = predictServiceMetrics.getMetricsValues().get(metricName);
                if (CollectionUtils.isEmpty(predictMetricsValues)) continue;
                for (PredictServiceMetrics.PredictMetricsValue predictMetricsValue : predictMetricsValues) {
                    if (predictMetricsValue == null) continue;
                    this.baselineCache.asMap().computeIfAbsent(predictMetricsValue.getTimeBucket() + "," + serviceName, k -> new HashMap()).put(metricName, predictMetricsValue);
                }
            }
        }
        return this.baselineCache.asMap().getOrDefault(key, Collections.emptyMap());
    }

    private List<PredictServiceMetrics> queryPredictMetrics0(List<ServiceMetrics> serviceMetrics, long startTimeBucket, long endTimeBucket) {
        AlarmBaselineRequest.Builder request = AlarmBaselineRequest.newBuilder();
        serviceMetrics.forEach(s -> {
            AlarmBaselineServiceMetricName.Builder serviceMetricsBuilder = AlarmBaselineServiceMetricName.newBuilder();
            serviceMetricsBuilder.setServiceName(s.getServiceName());
            serviceMetricsBuilder.addAllMetricNames(s.getMetricsNames());
            request.addServiceMetricNames(serviceMetricsBuilder);
        });
        request.setStartTimeBucket(startTimeBucket);
        request.setEndTimeBucket(endTimeBucket);
        request.setStep(TimeBucketStep.HOUR);
        AlarmBaselineResponse response = this.stub.queryPredictedMetrics(request.build());
        return response.getServiceMetricsList().stream().map(s -> {
            PredictServiceMetrics.PredictServiceMetricsBuilder builder = PredictServiceMetrics.builder();
            builder.serviceName(s.getServiceName());
            builder.metricsValues(s.getPredictionsList().stream().collect(Collectors.toMap(AlarmBaselineMetricPrediction::getName, p -> p.getValuesList().stream().map(v -> {
                PredictServiceMetrics.PredictMetricsValue.PredictMetricsValueBuilder valueBuilder = PredictServiceMetrics.PredictMetricsValue.builder();
                valueBuilder.timeBucket(v.getTimeBucket());
                if (v.hasSingleValue()) {
                    valueBuilder.singleValue(PredictServiceMetrics.PredictSingleValue.builder().value(v.getSingleValue().getValue().getValue()).upperValue(v.getSingleValue().getValue().getUpperValue()).lowerValue(v.getSingleValue().getValue().getLowerValue()).build());
                }
                if (v.hasLabeledValue()) {
                    valueBuilder.labeledValue(v.getLabeledValue().getValuesList().stream().map(l -> {
                        PredictServiceMetrics.PredictLabelValue.PredictLabelValueBuilder labelBuilder = PredictServiceMetrics.PredictLabelValue.builder();
                        labelBuilder.labels(l.getLabelsList().stream().collect(Collectors.toMap(KeyStringValuePair::getKey, KeyStringValuePair::getValue)));
                        labelBuilder.value(PredictServiceMetrics.PredictSingleValue.builder().value(l.getValue().getValue()).upperValue(l.getValue().getUpperValue()).lowerValue(l.getValue().getLowerValue()).build());
                        return labelBuilder.build();
                    }).collect(Collectors.toList()));
                }
                return valueBuilder.build();
            }).collect(Collectors.toList()))));
            return builder.build();
        }).collect(Collectors.toList());
    }
}

