/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.elasticsearch.query;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.skywalking.library.elasticsearch.requests.search.BoolQueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Query;
import org.apache.skywalking.library.elasticsearch.requests.search.QueryBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Search;
import org.apache.skywalking.library.elasticsearch.requests.search.SearchBuilder;
import org.apache.skywalking.library.elasticsearch.requests.search.Sort;
import org.apache.skywalking.library.elasticsearch.response.search.SearchHit;
import org.apache.skywalking.library.elasticsearch.response.search.SearchResponse;
import org.apache.skywalking.oap.server.core.query.type.EBPFProfilingSchedule;
import org.apache.skywalking.oap.server.core.storage.profiling.ebpf.IEBPFProfilingScheduleDAO;
import org.apache.skywalking.oap.server.library.client.elasticsearch.ElasticSearchClient;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.StorageModuleElasticsearchConfig;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.EsDAO;
import org.apache.skywalking.oap.server.storage.plugin.elasticsearch.base.IndexController;

public class EBPFProfilingScheduleEsDAO
extends EsDAO
implements IEBPFProfilingScheduleDAO {
    private final int scheduleTaskSize;

    public EBPFProfilingScheduleEsDAO(ElasticSearchClient client, StorageModuleElasticsearchConfig config) {
        super(client);
        this.scheduleTaskSize = config.getProfileTaskQueryMaxSize();
    }

    public List<EBPFProfilingSchedule> querySchedules(String taskId) throws IOException {
        String index = IndexController.LogicIndicesRegister.getPhysicalTableName("ebpf_profiling_schedule");
        BoolQueryBuilder query = Query.bool();
        if (IndexController.LogicIndicesRegister.isMergedTable("ebpf_profiling_schedule")) {
            query.must((QueryBuilder)Query.term((String)"metric_table", (Object)"ebpf_profiling_schedule"));
        }
        query.must((QueryBuilder)Query.term((String)"task_id", (Object)taskId));
        query.must((QueryBuilder)Query.range((String)"start_time"));
        SearchBuilder search = Search.builder().query((QueryBuilder)query).sort("start_time", Sort.Order.DESC).size(Integer.valueOf(this.scheduleTaskSize));
        SearchResponse response = ((ElasticSearchClient)this.getClient()).search(index, search.build());
        return response.getHits().getHits().stream().map(this::parseSchedule).collect(Collectors.toList());
    }

    private EBPFProfilingSchedule parseSchedule(SearchHit hit) {
        EBPFProfilingSchedule schedule = new EBPFProfilingSchedule();
        schedule.setScheduleId((String)hit.getSource().get("ebpf_profiling_schedule_id"));
        schedule.setTaskId((String)hit.getSource().get("task_id"));
        schedule.setProcessId((String)hit.getSource().get("process_id"));
        schedule.setStartTime(((Number)hit.getSource().get("start_time")).longValue());
        schedule.setEndTime(((Number)hit.getSource().get("end_time")).longValue());
        return schedule;
    }
}

