/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.graphql.protocol;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.multipart.MultipartFile;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import java.util.List;
import java.util.Map;

final class MultipartVariableMapper {
    private static final int INVALID_INT = -1;
    private static final Splitter SPLITTER = Splitter.on((String)".");
    private static final Mapper<Map<String, Object>> MAP_MAPPER = new Mapper<Map<String, Object>>(){

        @Override
        public Object set(Map<String, Object> location, String target, MultipartFile multipartFile) {
            return location.put(target, multipartFile);
        }

        @Override
        @Nullable
        public Object recurse(Map<String, Object> location, String target) {
            return location.get(target);
        }
    };
    private static final Mapper<List<Object>> LIST_MAPPER = new Mapper<List<Object>>(){

        @Override
        public Object set(List<Object> location, String target, MultipartFile multipartFile) {
            int value = MultipartVariableMapper.parseUnsignedInt(target);
            if (value == -1) {
                return location;
            }
            if (value >= location.size()) {
                return location;
            }
            return location.set(value, multipartFile);
        }

        @Override
        @Nullable
        public Object recurse(List<Object> location, String target) {
            int value = MultipartVariableMapper.parseUnsignedInt(target);
            if (value == -1) {
                return null;
            }
            if (value >= location.size()) {
                return null;
            }
            return location.get(value);
        }
    };

    static void mapVariable(String objectPath, Map<String, Object> variables, MultipartFile multipartFile) {
        ImmutableList segments = ImmutableList.copyOf((Iterable)SPLITTER.split((CharSequence)objectPath));
        if (segments.size() < 2) {
            throw new IllegalArgumentException("Invalid object-path: " + objectPath);
        }
        if (!"variables".equals(segments.get(0))) {
            throw new IllegalArgumentException("Can only map into variables: " + objectPath);
        }
        Object currentLocation = variables;
        for (int i = 1; i < segments.size(); ++i) {
            String segmentName = (String)segments.get(i);
            if (i == segments.size() - 1) {
                if (currentLocation instanceof Map) {
                    if (MAP_MAPPER.set((Map<String, Object>)currentLocation, segmentName, multipartFile) == null) continue;
                    throw new IllegalArgumentException("Expected null value when mapping: " + objectPath);
                }
                if (currentLocation instanceof List) {
                    if (LIST_MAPPER.set((List)currentLocation, segmentName, multipartFile) == null) continue;
                    throw new IllegalArgumentException("Expected null value when mapping: " + objectPath);
                }
                throw new IllegalArgumentException("Invalid type: " + currentLocation + " (expected: Map or List)");
            }
            if (currentLocation instanceof Map) {
                currentLocation = MAP_MAPPER.recurse((Map<String, Object>)currentLocation, segmentName);
            } else if (currentLocation instanceof List) {
                currentLocation = LIST_MAPPER.recurse((List)currentLocation, segmentName);
            }
            if (currentLocation != null) continue;
            throw new IllegalArgumentException("Found null intermediate value when trying to map: " + objectPath);
        }
    }

    private static int parseUnsignedInt(String value) {
        try {
            int parseInt = Integer.parseInt(value);
            if (parseInt < 0) {
                return -1;
            }
            return parseInt;
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }

    private MultipartVariableMapper() {
    }

    static interface Mapper<T> {
        @Nullable
        public Object set(T var1, String var2, MultipartFile var3);

        @Nullable
        public Object recurse(T var1, String var2);
    }
}

