/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.handlers.AbstractConfigurationEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.AbstractUserEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.BundleEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandler;
import org.apache.sling.feature.cpconverter.handlers.EntryHandlersManager;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultEntryHandlersManager
implements EntryHandlersManager {
    private final List<EntryHandler> entryHandlers = new LinkedList<EntryHandler>();

    public DefaultEntryHandlersManager() {
        this(Collections.emptyMap(), false, ContentPackage2FeatureModelConverter.SlingInitialContentPolicy.KEEP, new BundleSlingInitialContentExtractor(), "system");
    }

    public DefaultEntryHandlersManager(@NotNull Map<String, String> configs, boolean enforceConfigurationsAndBundlesBelowProperFolder, @NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy, @NotNull String systemUserRelPath) {
        this(configs, enforceConfigurationsAndBundlesBelowProperFolder, slingInitialContentPolicy, new BundleSlingInitialContentExtractor(), systemUserRelPath);
    }

    public DefaultEntryHandlersManager(@NotNull Map<String, String> configs, boolean enforceConfigurationsAndBundlesBelowProperFolder, @NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy, @NotNull BundleSlingInitialContentExtractor bundleSlingInitialContentExtractor, @NotNull String systemUserRelPath) {
        ServiceLoader<EntryHandler> entryHandlersLoader = ServiceLoader.load(EntryHandler.class);
        for (EntryHandler entryHandler : entryHandlersLoader) {
            if (configs.containsKey(entryHandler.getClass().getName())) {
                entryHandler = entryHandler.withConfig(configs.get(entryHandler.getClass().getName()));
            }
            if (entryHandler instanceof AbstractConfigurationEntryHandler) {
                ((AbstractConfigurationEntryHandler)entryHandler).setEnforceConfigurationBelowConfigFolder(enforceConfigurationsAndBundlesBelowProperFolder);
            } else if (entryHandler instanceof BundleEntryHandler) {
                ((BundleEntryHandler)entryHandler).setEnforceBundlesBelowInstallFolder(enforceConfigurationsAndBundlesBelowProperFolder);
                ((BundleEntryHandler)entryHandler).setSlingInitialContentPolicy(slingInitialContentPolicy);
                ((BundleEntryHandler)entryHandler).setBundleSlingInitialContentExtractor(bundleSlingInitialContentExtractor);
            } else if (entryHandler instanceof AbstractUserEntryHandler) {
                ((AbstractUserEntryHandler)entryHandler).setSystemUserRelPath(systemUserRelPath);
            }
            this.addEntryHandler(entryHandler);
        }
    }

    @Override
    public void addEntryHandler(@NotNull EntryHandler handler) {
        this.entryHandlers.add(handler);
    }

    @Override
    @Nullable
    public EntryHandler getEntryHandlerByEntryPath(@NotNull String path) {
        for (EntryHandler entryHandler : this.entryHandlers) {
            if (!entryHandler.matches(path)) continue;
            return entryHandler;
        }
        return null;
    }
}

