/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.evaluation.Silhouette;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette;
import org.apache.spark.ml.evaluation.SquaredEuclideanSilhouette$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function4;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class SquaredEuclideanSilhouette$
extends Silhouette {
    public static final SquaredEuclideanSilhouette$ MODULE$ = new SquaredEuclideanSilhouette$();
    private static boolean kryoRegistrationPerformed = false;

    public void registerKryoClasses(SparkContext sc) {
        block0: {
            if (kryoRegistrationPerformed) break block0;
            sc.getConf().registerKryoClasses((Class[])((Object[])new Class[]{SquaredEuclideanSilhouette.ClusterStats.class}));
            kryoRegistrationPerformed = true;
        }
    }

    public Map<Object, SquaredEuclideanSilhouette.ClusterStats> computeClusterStats(Dataset<Row> df, String predictionCol, String featuresCol, String weightCol) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(df, featuresCol);
        RDD clustersStatsRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(featuresCol), functions$.MODULE$.col("squaredNorm"), functions$.MODULE$.col(weightCol)})).rdd().map((Function1 & Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)row.getDouble(0)), (Object)new Tuple3(row.getAs(1), (Object)BoxesRunTime.boxToDouble((double)row.getDouble(2)), (Object)BoxesRunTime.boxToDouble((double)row.getDouble(3)))), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).aggregateByKey((Object)new Tuple3(null, (Object)BoxesRunTime.boxToDouble((double)0.0), (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple6 tuple6;
            block5: {
                Tuple2 tuple2;
                block2: {
                    double weight;
                    double squaredNorm;
                    Vector features;
                    double weightSum;
                    double squaredNormSum;
                    DenseVector featureSum;
                    block4: {
                        Tuple2 tuple22;
                        block3: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            Tuple2 tuple23 = tuple2;
                            tuple22 = tuple23;
                            if (tuple22 == null) break block3;
                            Tuple3 tuple3 = (Tuple3)tuple22._1();
                            Tuple3 tuple32 = (Tuple3)tuple22._2();
                            if (tuple3 == null) break block3;
                            featureSum = (DenseVector)tuple3._1();
                            squaredNormSum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                            weightSum = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                            if (tuple32 == null) break block3;
                            features = (Vector)tuple32._1();
                            squaredNorm = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                            weight = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                            if (features != null) break block4;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    Vector vector = features;
                    tuple6 = new Tuple6((Object)featureSum, (Object)BoxesRunTime.boxToDouble((double)squaredNormSum), (Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)vector, (Object)BoxesRunTime.boxToDouble((double)squaredNorm), (Object)BoxesRunTime.boxToDouble((double)weight));
                    break block5;
                }
                throw new MatchError((Object)tuple2);
            }
            Tuple6 tuple62 = tuple6;
            DenseVector featureSum = (DenseVector)tuple62._1();
            double squaredNormSum = BoxesRunTime.unboxToDouble((Object)tuple62._2());
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple62._3());
            Vector features = (Vector)tuple62._4();
            double squaredNorm = BoxesRunTime.unboxToDouble((Object)tuple62._5());
            double weight = BoxesRunTime.unboxToDouble((Object)tuple62._6());
            DenseVector theFeatureSum = featureSum == null ? Vectors$.MODULE$.zeros(numFeatures).toDense() : featureSum;
            BLAS$.MODULE$.axpy(weight, features, (Vector)theFeatureSum);
            Tuple3 tuple3 = new Tuple3((Object)theFeatureSum, (Object)BoxesRunTime.boxToDouble((double)(squaredNormSum + squaredNorm * weight)), (Object)BoxesRunTime.boxToDouble((double)(weightSum + weight)));
            return tuple3;
        }, (Function2 & Serializable)(x0$2, x1$2) -> {
            DenseVector denseVector;
            double weightSum2;
            double squaredNormSum2;
            double weightSum1;
            double squaredNormSum1;
            block10: {
                Tuple2 tuple2;
                block7: {
                    double weightSum12;
                    double squaredNormSum12;
                    DenseVector featureSum1;
                    Tuple3 tuple3;
                    block9: {
                        Tuple2 tuple22;
                        block8: {
                            tuple2 = new Tuple2(x0$2, x1$2);
                            if (tuple2 == null) break block7;
                            Tuple2 tuple23 = tuple2;
                            tuple22 = tuple23;
                            if (tuple22 == null) break block8;
                            Tuple3 tuple32 = (Tuple3)tuple22._1();
                            tuple3 = (Tuple3)tuple22._2();
                            if (tuple32 == null) break block8;
                            featureSum1 = (DenseVector)tuple32._1();
                            squaredNormSum12 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                            weightSum12 = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                            if (tuple3 != null) break block9;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    DenseVector featureSum2 = (DenseVector)tuple3._1();
                    double squaredNormSum22 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    double weightSum22 = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    Tuple6 tuple6 = new Tuple6((Object)featureSum1, (Object)BoxesRunTime.boxToDouble((double)squaredNormSum12), (Object)BoxesRunTime.boxToDouble((double)weightSum12), (Object)featureSum2, (Object)BoxesRunTime.boxToDouble((double)squaredNormSum22), (Object)BoxesRunTime.boxToDouble((double)weightSum22));
                    Tuple6 tuple62 = tuple6;
                    DenseVector featureSum12 = (DenseVector)tuple62._1();
                    squaredNormSum1 = BoxesRunTime.unboxToDouble((Object)tuple62._2());
                    weightSum1 = BoxesRunTime.unboxToDouble((Object)tuple62._3());
                    DenseVector featureSum22 = (DenseVector)tuple62._4();
                    squaredNormSum2 = BoxesRunTime.unboxToDouble((Object)tuple62._5());
                    weightSum2 = BoxesRunTime.unboxToDouble((Object)tuple62._6());
                    if (featureSum12 == null) {
                        denseVector = featureSum22;
                    } else if (featureSum22 == null) {
                        denseVector = featureSum12;
                    } else {
                        BLAS$.MODULE$.axpy(1.0, (Vector)featureSum22, (Vector)featureSum12);
                        denseVector = featureSum12;
                    }
                    break block10;
                }
                throw new MatchError((Object)tuple2);
            }
            DenseVector theFeatureSum = denseVector;
            Tuple3 tuple3 = new Tuple3((Object)theFeatureSum, (Object)BoxesRunTime.boxToDouble((double)(squaredNormSum1 + squaredNormSum2)), (Object)BoxesRunTime.boxToDouble((double)(weightSum1 + weightSum2)));
            return tuple3;
        }, ClassTag$.MODULE$.apply(Tuple3.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(clustersStatsRDD, (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).collectAsMap().mapValues((Function1 & Serializable)x0$3 -> {
            double d;
            DenseVector denseVector;
            double weightSum;
            block3: {
                Tuple3 tuple3;
                block2: {
                    tuple3 = x0$3;
                    if (tuple3 == null) break block2;
                    DenseVector featureSum = (DenseVector)tuple3._1();
                    double squaredNormSum = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                    weightSum = BoxesRunTime.unboxToDouble((Object)tuple3._3());
                    if (featureSum == null) break block2;
                    denseVector = featureSum;
                    if (!true) break block2;
                    d = squaredNormSum;
                    if (true) break block3;
                }
                throw new MatchError((Object)tuple3);
            }
            double d2 = weightSum;
            SquaredEuclideanSilhouette.ClusterStats clusterStats = new SquaredEuclideanSilhouette.ClusterStats((Vector)denseVector, d, d2);
            return clusterStats;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public double computeSilhouetteCoefficient(Broadcast<Map<Object, SquaredEuclideanSilhouette.ClusterStats>> broadcastedClustersMap, Vector point, double clusterId, double weight, double squaredNorm) {
        return this.pointSilhouetteCoefficient((Set<Object>)((scala.collection.immutable.MapOps)broadcastedClustersMap.value()).keySet(), clusterId, ((SquaredEuclideanSilhouette.ClusterStats)((MapOps)broadcastedClustersMap.value()).apply((Object)BoxesRunTime.boxToDouble((double)clusterId))).weightSum(), weight, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)targetClusterId -> SquaredEuclideanSilhouette$.compute$1(targetClusterId, broadcastedClustersMap, point, squaredNorm));
    }

    public double computeSilhouetteScore(Dataset<?> dataset, String predictionCol, String featuresCol, String weightCol) {
        this.registerKryoClasses(dataset.sparkSession().sparkContext());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1() {
            }
        }
        UserDefinedFunction squaredNormUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)scala.math.package$.MODULE$.pow(Vectors$.MODULE$.norm(features, 2.0), 2.0)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator1$1()));
        Dataset dfWithSquaredNorm = dataset.withColumn("squaredNorm", squaredNormUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})));
        Map<Object, SquaredEuclideanSilhouette.ClusterStats> clustersStatsMap = this.computeClusterStats((Dataset<Row>)dfWithSquaredNorm, predictionCol, featuresCol, weightCol);
        Predef$.MODULE$.assert(clustersStatsMap.size() > 1, (Function0 & Serializable)() -> "Number of clusters must be greater than one.");
        Broadcast bClustersStatsMap = dataset.sparkSession().sparkContext().broadcast(clustersStatsMap, ClassTag$.MODULE$.apply(Map.class));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1() {
            }
        }
        UserDefinedFunction computeSilhouetteCoefficientUDF = functions$.MODULE$.udf((Function4 & Serializable)(x$4, x$5, x$6, x$7) -> BoxesRunTime.boxToDouble((double)SquaredEuclideanSilhouette$.MODULE$.computeSilhouetteCoefficient((Broadcast<Map<Object, SquaredEuclideanSilhouette.ClusterStats>>)bClustersStatsMap, x$4, BoxesRunTime.unboxToDouble((Object)x$5), BoxesRunTime.unboxToDouble((Object)x$6), BoxesRunTime.unboxToDouble((Object)x$7))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_evaluation_SquaredEuclideanSilhouette$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        double silhouetteScore = this.overallScore((Dataset<Row>)dfWithSquaredNorm, computeSilhouetteCoefficientUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol), functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(weightCol), functions$.MODULE$.col("squaredNorm")})), functions$.MODULE$.col(weightCol));
        bClustersStatsMap.destroy();
        return silhouetteScore;
    }

    private static final double compute$1(double targetClusterId, Broadcast broadcastedClustersMap$1, Vector point$1, double squaredNorm$1) {
        SquaredEuclideanSilhouette.ClusterStats clusterStats = (SquaredEuclideanSilhouette.ClusterStats)((MapOps)broadcastedClustersMap$1.value()).apply((Object)BoxesRunTime.boxToDouble((double)targetClusterId));
        double pointDotClusterFeaturesSum = BLAS$.MODULE$.dot(point$1, clusterStats.featureSum());
        return squaredNorm$1 + clusterStats.squaredNormSum() / clusterStats.weightSum() - (double)2 * pointDotClusterFeaturesSum / clusterStats.weightSum();
    }

    private SquaredEuclideanSilhouette$() {
    }
}

