/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class TreePoint$
implements Serializable {
    public static final TreePoint$ MODULE$ = new TreePoint$();

    public RDD<TreePoint> convertToTreeRDD(RDD<Instance> input, Split[][] splits, DecisionTreeMetadata metadata) {
        int[] featureArity = new int[metadata.numFeatures()];
        for (int featureIndex = 0; featureIndex < metadata.numFeatures(); ++featureIndex) {
            featureArity[featureIndex] = BoxesRunTime.unboxToInt((Object)metadata.featureArity().getOrElse((Object)BoxesRunTime.boxToInteger((int)featureIndex), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        }
        double[][] thresholds = (double[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.intArrayOps(featureArity))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int arity = tuple2._1$mcI$sp();
            int idx = tuple2._2$mcI$sp();
            double[] dArray = arity == 0 ? (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])splits[idx]), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)TreePoint$.$anonfun$convertToTreeRDD$3(x$1)), (ClassTag)ClassTag$.MODULE$.Double()) : Array$.MODULE$.emptyDoubleArray();
            return dArray;
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        return input.map((Function1 & Serializable)x -> MODULE$.labeledPointToTreePoint((Instance)x, thresholds, featureArity), ClassTag$.MODULE$.apply(TreePoint.class));
    }

    private TreePoint labeledPointToTreePoint(Instance instance, double[][] thresholds, int[] featureArity) {
        int numFeatures = instance.features().size();
        int[] arr = new int[numFeatures];
        for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
            arr[featureIndex] = this.findBin(featureIndex, instance, featureArity[featureIndex], thresholds[featureIndex]);
        }
        return new TreePoint(instance.label(), arr, instance.weight());
    }

    private int findBin(int featureIndex, Instance instance, int featureArity, double[] thresholds) {
        int n;
        double featureValue = instance.features().apply(featureIndex);
        if (featureArity == 0) {
            int idx = Arrays.binarySearch(thresholds, featureValue);
            n = idx >= 0 ? idx : -idx - 1;
        } else {
            if (featureValue < 0.0 || featureValue >= (double)featureArity) {
                throw new IllegalArgumentException(new StringBuilder(0).append("DecisionTree given invalid data:").append(new StringBuilder(48).append(" Feature ").append(featureIndex).append(" is categorical with values in {0,...,").append(featureArity - 1).append(",").toString()).append(new StringBuilder(35).append(" but a data point gives it value ").append(featureValue).append(".\n").toString()).append(new StringBuilder(18).append("  Bad data point: ").append(instance).toString()).toString());
            }
            n = (int)featureValue;
        }
        return n;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TreePoint$.class);
    }

    public static final /* synthetic */ double $anonfun$convertToTreeRDD$3(Split x$1) {
        return ((ContinuousSplit)x$1).threshold();
    }

    private TreePoint$() {
    }
}

