/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.evaluation.CosineSilhouette$;
import org.apache.spark.ml.evaluation.Silhouette;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class CosineSilhouette$
extends Silhouette {
    public static final CosineSilhouette$ MODULE$ = new CosineSilhouette$();
    private static final String normalizedFeaturesColName = "normalizedFeatures";

    public Map<Object, Tuple2<Vector, Object>> computeClusterStats(Dataset<Row> df, String featuresCol, String predictionCol, String weightCol) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(df, featuresCol);
        RDD clustersStatsRDD = RDD$.MODULE$.rddToPairRDDFunctions(df.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(normalizedFeaturesColName), functions$.MODULE$.col(weightCol)})).rdd().map((Function1 & Serializable)row -> new Tuple2((Object)BoxesRunTime.boxToDouble((double)row.getDouble(0)), (Object)new Tuple2(row.getAs(1), (Object)BoxesRunTime.boxToDouble((double)row.getDouble(2)))), ClassTag$.MODULE$.apply(Tuple2.class)), (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).aggregateByKey((Object)new Tuple2(null, (Object)BoxesRunTime.boxToDouble((double)0.0)), (Function2 & Serializable)(x0$1, x1$1) -> {
            Tuple4 tuple4;
            block5: {
                Tuple2 tuple2;
                block2: {
                    double weightSum;
                    DenseVector normalizedFeaturesSum;
                    Tuple2 tuple22;
                    block4: {
                        Tuple2 tuple23;
                        block3: {
                            tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 == null) break block2;
                            Tuple2 tuple24 = tuple2;
                            tuple23 = tuple24;
                            if (tuple23 == null) break block3;
                            Tuple2 tuple25 = (Tuple2)tuple23._1();
                            tuple22 = (Tuple2)tuple23._2();
                            if (tuple25 == null) break block3;
                            normalizedFeaturesSum = (DenseVector)tuple25._1();
                            weightSum = tuple25._2$mcD$sp();
                            if (tuple22 != null) break block4;
                        }
                        throw new MatchError((Object)tuple23);
                    }
                    Vector normalizedFeatures = (Vector)tuple22._1();
                    double weight = tuple22._2$mcD$sp();
                    tuple4 = new Tuple4((Object)normalizedFeaturesSum, (Object)BoxesRunTime.boxToDouble((double)weightSum), (Object)normalizedFeatures, (Object)BoxesRunTime.boxToDouble((double)weight));
                    break block5;
                }
                throw new MatchError((Object)tuple2);
            }
            Tuple4 tuple42 = tuple4;
            DenseVector normalizedFeaturesSum = (DenseVector)tuple42._1();
            double weightSum = BoxesRunTime.unboxToDouble((Object)tuple42._2());
            Vector normalizedFeatures = (Vector)tuple42._3();
            double weight = BoxesRunTime.unboxToDouble((Object)tuple42._4());
            DenseVector theNormalizedFeaturesSum = normalizedFeaturesSum == null ? Vectors$.MODULE$.zeros(numFeatures).toDense() : normalizedFeaturesSum;
            BLAS$.MODULE$.axpy(weight, normalizedFeatures, (Vector)theNormalizedFeaturesSum);
            Tuple2 tuple2 = new Tuple2((Object)theNormalizedFeaturesSum, (Object)BoxesRunTime.boxToDouble((double)(weightSum + weight)));
            return tuple2;
        }, (Function2 & Serializable)(x0$2, x1$2) -> {
            DenseVector denseVector;
            double weightSum2;
            double weightSum1;
            block10: {
                Tuple2 tuple2;
                block7: {
                    double weightSum12;
                    DenseVector normalizedFeaturesSum1;
                    Tuple2 tuple22;
                    block9: {
                        Tuple2 tuple23;
                        block8: {
                            tuple2 = new Tuple2(x0$2, x1$2);
                            if (tuple2 == null) break block7;
                            Tuple2 tuple24 = tuple2;
                            tuple23 = tuple24;
                            if (tuple23 == null) break block8;
                            Tuple2 tuple25 = (Tuple2)tuple23._1();
                            tuple22 = (Tuple2)tuple23._2();
                            if (tuple25 == null) break block8;
                            normalizedFeaturesSum1 = (DenseVector)tuple25._1();
                            weightSum12 = tuple25._2$mcD$sp();
                            if (tuple22 != null) break block9;
                        }
                        throw new MatchError((Object)tuple23);
                    }
                    DenseVector normalizedFeaturesSum2 = (DenseVector)tuple22._1();
                    double weightSum22 = tuple22._2$mcD$sp();
                    Tuple4 tuple4 = new Tuple4((Object)normalizedFeaturesSum1, (Object)BoxesRunTime.boxToDouble((double)weightSum12), (Object)normalizedFeaturesSum2, (Object)BoxesRunTime.boxToDouble((double)weightSum22));
                    Tuple4 tuple42 = tuple4;
                    DenseVector normalizedFeaturesSum12 = (DenseVector)tuple42._1();
                    weightSum1 = BoxesRunTime.unboxToDouble((Object)tuple42._2());
                    DenseVector normalizedFeaturesSum22 = (DenseVector)tuple42._3();
                    weightSum2 = BoxesRunTime.unboxToDouble((Object)tuple42._4());
                    if (normalizedFeaturesSum12 == null) {
                        denseVector = normalizedFeaturesSum22;
                    } else if (normalizedFeaturesSum22 == null) {
                        denseVector = normalizedFeaturesSum12;
                    } else {
                        BLAS$.MODULE$.axpy(1.0, (Vector)normalizedFeaturesSum22, (Vector)normalizedFeaturesSum12);
                        denseVector = normalizedFeaturesSum12;
                    }
                    break block10;
                }
                throw new MatchError((Object)tuple2);
            }
            DenseVector theNormalizedFeaturesSum = denseVector;
            Tuple2 tuple2 = new Tuple2((Object)theNormalizedFeaturesSum, (Object)BoxesRunTime.boxToDouble((double)(weightSum1 + weightSum2)));
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(clustersStatsRDD, (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).collectAsMap().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public double computeSilhouetteCoefficient(Broadcast<Map<Object, Tuple2<Vector, Object>>> broadcastedClustersMap, Vector normalizedFeatures, double clusterId, double weight) {
        return this.pointSilhouetteCoefficient((Set<Object>)((scala.collection.immutable.MapOps)broadcastedClustersMap.value()).keySet(), clusterId, ((Tuple2)((MapOps)broadcastedClustersMap.value()).apply((Object)BoxesRunTime.boxToDouble((double)clusterId)))._2$mcD$sp(), weight, (Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable)targetClusterId -> CosineSilhouette$.compute$2(targetClusterId, broadcastedClustersMap, normalizedFeatures));
    }

    public double computeSilhouetteScore(Dataset<?> dataset, String predictionCol, String featuresCol, String weightCol) {
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2() {
            }
        }
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2() {
            }
        }
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        UserDefinedFunction normalizeFeatureUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> {
            double norm = Vectors$.MODULE$.norm(features, 2.0);
            BLAS$.MODULE$.scal(1.0 / norm, features);
            return features;
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator1$2()), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator2$2()));
        Dataset dfWithNormalizedFeatures = dataset.withColumn(normalizedFeaturesColName, normalizeFeatureUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(featuresCol)})));
        Map<Object, Tuple2<Vector, Object>> clustersStatsMap = this.computeClusterStats((Dataset<Row>)dfWithNormalizedFeatures, featuresCol, predictionCol, weightCol);
        Predef$.MODULE$.assert(clustersStatsMap.size() > 1, (Function0 & Serializable)() -> "Number of clusters must be greater than one.");
        Broadcast bClustersStatsMap = dataset.sparkSession().sparkContext().broadcast(clustersStatsMap, ClassTag$.MODULE$.apply(Map.class));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
            }

            public Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1() {
            }
        }
        UserDefinedFunction computeSilhouetteCoefficientUDF = functions$.MODULE$.udf((Function3 & Serializable)(x$11, x$12, x$13) -> BoxesRunTime.boxToDouble((double)CosineSilhouette$.MODULE$.computeSilhouetteCoefficient((Broadcast<Map<Object, Tuple2<Vector, Object>>>)bClustersStatsMap, x$11, BoxesRunTime.unboxToDouble((Object)x$12), BoxesRunTime.unboxToDouble((Object)x$13))), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_ml_evaluation_CosineSilhouette$$typecreator3$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double());
        double silhouetteScore = this.overallScore((Dataset<Row>)dfWithNormalizedFeatures, computeSilhouetteCoefficientUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(normalizedFeaturesColName), functions$.MODULE$.col(predictionCol).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(weightCol)})), functions$.MODULE$.col(weightCol));
        bClustersStatsMap.destroy();
        return silhouetteScore;
    }

    private static final double compute$2(double targetClusterId, Broadcast broadcastedClustersMap$2, Vector normalizedFeatures$1) {
        Tuple2 tuple2 = (Tuple2)((MapOps)broadcastedClustersMap$2.value()).apply((Object)BoxesRunTime.boxToDouble((double)targetClusterId));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector normalizedFeatureSum = (Vector)tuple2._1();
        double numOfPoints = tuple2._2$mcD$sp();
        Tuple2 tuple22 = new Tuple2((Object)normalizedFeatureSum, (Object)BoxesRunTime.boxToDouble((double)numOfPoints));
        Tuple2 tuple23 = tuple22;
        Vector normalizedFeatureSum2 = (Vector)tuple23._1();
        double numOfPoints2 = tuple23._2$mcD$sp();
        return 1.0 - BLAS$.MODULE$.dot(normalizedFeatures$1, normalizedFeatureSum2) / numOfPoints2;
    }

    private CosineSilhouette$() {
    }
}

