% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mllib_clustering.R
\name{fitted}
\alias{fitted}
\alias{fitted,KMeansModel-method}
\title{Get fitted result from a k-means model}
\usage{
fitted(object, ...)

\S4method{fitted}{KMeansModel}(object, method = c("centers", "classes"))
}
\arguments{
\item{object}{a fitted k-means model.}

\item{...}{additional argument(s) passed to the method.}

\item{method}{type of fitted results, \code{"centers"} for cluster centers
or \code{"classes"} for assigned classes.}
}
\value{
\code{fitted} returns a SparkDataFrame containing fitted values.
}
\description{
Get fitted result from a k-means model, similarly to R's fitted().
Note: A saved-loaded model does not support this method.
}
\note{
fitted since 2.0.0
}
\examples{
\dontrun{
model <- spark.kmeans(trainingData, ~ ., 2)
fitted.model <- fitted(model)
showDF(fitted.model)
}
}
