/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.math3.linear;

import org.apache.hadoop.shaded.org.apache.commons.math3.linear.MatrixUtils;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import org.apache.hadoop.shaded.org.apache.commons.math3.linear.RealMatrix;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.FastMath;
import org.apache.hadoop.shaded.org.apache.commons.math3.util.Precision;

class HessenbergTransformer {
    private final double[][] householderVectors;
    private final double[] ort;
    private RealMatrix cachedP;
    private RealMatrix cachedPt;
    private RealMatrix cachedH;

    HessenbergTransformer(RealMatrix matrix) {
        if (!matrix.isSquare()) {
            throw new NonSquareMatrixException(matrix.getRowDimension(), matrix.getColumnDimension());
        }
        int m4 = matrix.getRowDimension();
        this.householderVectors = matrix.getData();
        this.ort = new double[m4];
        this.cachedP = null;
        this.cachedPt = null;
        this.cachedH = null;
        this.transform();
    }

    public RealMatrix getP() {
        if (this.cachedP == null) {
            int j;
            int n = this.householderVectors.length;
            int high = n - 1;
            double[][] pa = new double[n][n];
            for (int i = 0; i < n; ++i) {
                for (j = 0; j < n; ++j) {
                    pa[i][j] = i == j ? 1.0 : 0.0;
                }
            }
            for (int m4 = high - 1; m4 >= 1; --m4) {
                if (this.householderVectors[m4][m4 - 1] == 0.0) continue;
                for (int i = m4 + 1; i <= high; ++i) {
                    this.ort[i] = this.householderVectors[i][m4 - 1];
                }
                for (j = m4; j <= high; ++j) {
                    int i;
                    double g2 = 0.0;
                    for (i = m4; i <= high; ++i) {
                        g2 += this.ort[i] * pa[i][j];
                    }
                    g2 = g2 / this.ort[m4] / this.householderVectors[m4][m4 - 1];
                    for (i = m4; i <= high; ++i) {
                        double[] dArray = pa[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] + g2 * this.ort[i];
                    }
                }
            }
            this.cachedP = MatrixUtils.createRealMatrix(pa);
        }
        return this.cachedP;
    }

    public RealMatrix getPT() {
        if (this.cachedPt == null) {
            this.cachedPt = this.getP().transpose();
        }
        return this.cachedPt;
    }

    public RealMatrix getH() {
        if (this.cachedH == null) {
            int m4 = this.householderVectors.length;
            double[][] h2 = new double[m4][m4];
            for (int i = 0; i < m4; ++i) {
                if (i > 0) {
                    h2[i][i - 1] = this.householderVectors[i][i - 1];
                }
                for (int j = i; j < m4; ++j) {
                    h2[i][j] = this.householderVectors[i][j];
                }
            }
            this.cachedH = MatrixUtils.createRealMatrix(h2);
        }
        return this.cachedH;
    }

    double[][] getHouseholderVectorsRef() {
        return this.householderVectors;
    }

    private void transform() {
        int n = this.householderVectors.length;
        int high = n - 1;
        for (int m4 = 1; m4 <= high - 1; ++m4) {
            double f;
            double scale = 0.0;
            for (int i = m4; i <= high; ++i) {
                scale += FastMath.abs(this.householderVectors[i][m4 - 1]);
            }
            if (Precision.equals(scale, 0.0)) continue;
            double h2 = 0.0;
            for (int i = high; i >= m4; --i) {
                this.ort[i] = this.householderVectors[i][m4 - 1] / scale;
                h2 += this.ort[i] * this.ort[i];
            }
            double g2 = this.ort[m4] > 0.0 ? -FastMath.sqrt(h2) : FastMath.sqrt(h2);
            h2 -= this.ort[m4] * g2;
            int n2 = m4;
            this.ort[n2] = this.ort[n2] - g2;
            for (int j = m4; j < n; ++j) {
                int i;
                f = 0.0;
                for (i = high; i >= m4; --i) {
                    f += this.ort[i] * this.householderVectors[i][j];
                }
                f /= h2;
                for (i = m4; i <= high; ++i) {
                    double[] dArray = this.householderVectors[i];
                    int n3 = j;
                    dArray[n3] = dArray[n3] - f * this.ort[i];
                }
            }
            for (int i = 0; i <= high; ++i) {
                int j;
                f = 0.0;
                for (j = high; j >= m4; --j) {
                    f += this.ort[j] * this.householderVectors[i][j];
                }
                f /= h2;
                for (j = m4; j <= high; ++j) {
                    double[] dArray = this.householderVectors[i];
                    int n4 = j;
                    dArray[n4] = dArray[n4] - f * this.ort[j];
                }
            }
            this.ort[m4] = scale * this.ort[m4];
            this.householderVectors[m4][m4 - 1] = scale * g2;
        }
    }
}

