/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.catalyst.util.QuotingUtils$;
import org.apache.spark.sql.errors.DataTypeErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.exceptions.SqlScriptingException;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class SqlScriptingErrors$ {
    public static final SqlScriptingErrors$ MODULE$ = new SqlScriptingErrors$();

    public Throwable duplicateLabels(Origin origin, String label) {
        Origin x$1 = origin;
        String x$2 = "LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId(label))}));
        return new SqlScriptingException("LABEL_OR_FOR_VARIABLE_ALREADY_EXISTS", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable labelsMismatch(Origin origin, String beginLabel, String endLabel) {
        Origin x$1 = origin;
        String x$2 = "LABELS_MISMATCH";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"beginLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId(beginLabel)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId(endLabel))}));
        return new SqlScriptingException("LABELS_MISMATCH", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable endLabelWithoutBeginLabel(Origin origin, String endLabel) {
        Origin x$1 = origin;
        String x$2 = "END_LABEL_WITHOUT_BEGIN_LABEL";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"endLabel"), (Object)DataTypeErrors$.MODULE$.toSQLId(endLabel))}));
        return new SqlScriptingException("END_LABEL_WITHOUT_BEGIN_LABEL", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable labelOrForVariableNameForbidden(Origin origin, String label) {
        Origin x$1 = origin;
        String x$2 = "LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"label"), (Object)DataTypeErrors$.MODULE$.toSQLId(label))}));
        return new SqlScriptingException("LABEL_OR_FOR_VARIABLE_NAME_FORBIDDEN", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable variableDeclarationNotAllowedInScope(Origin origin, Seq<String> varName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)DataTypeErrors$.MODULE$.toSQLId(varName))}));
        return new SqlScriptingException("INVALID_VARIABLE_DECLARATION.NOT_ALLOWED_IN_SCOPE", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable variableDeclarationOnlyAtBeginning(Origin origin, Seq<String> varName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"varName"), (Object)DataTypeErrors$.MODULE$.toSQLId(varName))}));
        return new SqlScriptingException("INVALID_VARIABLE_DECLARATION.ONLY_AT_BEGINNING", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable invalidBooleanStatement(Origin origin, String stmt) {
        Origin x$1 = origin;
        String x$2 = "INVALID_BOOLEAN_STATEMENT";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidStatement"), (Object)QueryExecutionErrors$.MODULE$.toSQLStmt(stmt))}));
        return new SqlScriptingException("INVALID_BOOLEAN_STATEMENT", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable sqlScriptingNotEnabled(Origin origin) {
        return new SqlScriptingException("UNSUPPORTED_FEATURE.SQL_SCRIPTING", null, origin, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlScriptingEnabled"), (Object)QuotingUtils$.MODULE$.toSQLConf(SQLConf$.MODULE$.SQL_SCRIPTING_ENABLED().key()))}))));
    }

    public Throwable positionalParametersAreNotSupportedWithSqlScripting() {
        Object x$1 = null;
        String x$2 = "UNSUPPORTED_FEATURE.SQL_SCRIPTING_WITH_POSITIONAL_PARAMETERS";
        Object x$3 = null;
        Map x$4 = Predef$.MODULE$.Map().empty();
        return new SqlScriptingException("UNSUPPORTED_FEATURE.SQL_SCRIPTING_WITH_POSITIONAL_PARAMETERS", null, null, (Map<String, String>)x$4);
    }

    public Throwable labelDoesNotExist(Origin origin, String labelName, String statementType) {
        Origin x$1 = origin;
        String x$2 = "INVALID_LABEL_USAGE.DOES_NOT_EXIST";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)QueryExecutionErrors$.MODULE$.toSQLStmt(labelName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statementType"), (Object)statementType)}));
        return new SqlScriptingException("INVALID_LABEL_USAGE.DOES_NOT_EXIST", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable invalidIterateLabelUsageForCompound(Origin origin, String labelName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)QueryExecutionErrors$.MODULE$.toSQLStmt(labelName))}));
        return new SqlScriptingException("INVALID_LABEL_USAGE.ITERATE_IN_COMPOUND", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable labelCannotBeQualified(Origin origin, String labelName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"labelName"), (Object)QueryExecutionErrors$.MODULE$.toSQLStmt(labelName))}));
        return new SqlScriptingException("INVALID_LABEL_USAGE.QUALIFIED_LABEL_NAME", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable conditionCannotBeQualified(Origin origin, String conditionName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)QueryExecutionErrors$.MODULE$.toSQLStmt(conditionName))}));
        return new SqlScriptingException("INVALID_ERROR_CONDITION_DECLARATION.QUALIFIED_CONDITION_NAME", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable conditionDeclarationNotAtStartOfCompound(Origin origin, String conditionName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId(conditionName))}));
        return new SqlScriptingException("INVALID_ERROR_CONDITION_DECLARATION.NOT_AT_START_OF_COMPOUND_STATEMENT", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable conditionDeclarationContainsSpecialCharacter(Origin origin, String conditionName) {
        Origin x$1 = origin;
        String x$2 = "INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"conditionName"), (Object)DataTypeErrors$.MODULE$.toSQLId(conditionName))}));
        return new SqlScriptingException("INVALID_ERROR_CONDITION_DECLARATION.SPECIAL_CHARACTER_FOUND", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable duplicateConditionInScope(Origin origin, String condition) {
        Origin x$1 = origin;
        String x$2 = "DUPLICATE_CONDITION_IN_SCOPE";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)DataTypeErrors$.MODULE$.toSQLId(condition))}));
        return new SqlScriptingException("DUPLICATE_CONDITION_IN_SCOPE", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable handlerDeclarationInWrongPlace(Origin origin) {
        Origin x$1 = origin;
        String x$2 = "INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION";
        Object x$3 = null;
        Map x$4 = Predef$.MODULE$.Map().empty();
        return new SqlScriptingException("INVALID_HANDLER_DECLARATION.WRONG_PLACE_OF_DECLARATION", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable duplicateConditionInHandlerDeclaration(Origin origin, String condition) {
        Origin x$1 = origin;
        String x$2 = "INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)condition)}));
        return new SqlScriptingException("INVALID_HANDLER_DECLARATION.DUPLICATE_CONDITION_IN_HANDLER_DECLARATION", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable duplicateSqlStateInHandlerDeclaration(Origin origin, String sqlState) {
        Origin x$1 = origin;
        String x$2 = "INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)sqlState)}));
        return new SqlScriptingException("INVALID_HANDLER_DECLARATION.DUPLICATE_SQLSTATE_IN_HANDLER_DECLARATION", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable duplicateHandlerForSameCondition(Origin origin, String condition) {
        Origin x$1 = origin;
        String x$2 = "DUPLICATE_EXCEPTION_HANDLER.CONDITION";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)condition)}));
        return new SqlScriptingException("DUPLICATE_EXCEPTION_HANDLER.CONDITION", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable duplicateHandlerForSameSqlState(Origin origin, String sqlState) {
        Origin x$1 = origin;
        String x$2 = "DUPLICATE_EXCEPTION_HANDLER.SQLSTATE";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)sqlState)}));
        return new SqlScriptingException("DUPLICATE_EXCEPTION_HANDLER.SQLSTATE", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable continueHandlerNotSupported(Origin origin) {
        Origin x$1 = origin;
        String x$2 = "UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER";
        Object x$3 = null;
        Map x$4 = Predef$.MODULE$.Map().empty();
        return new SqlScriptingException("UNSUPPORTED_FEATURE.CONTINUE_EXCEPTION_HANDLER", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable invalidSqlStateValue(Origin origin, String sqlState) {
        Origin x$1 = origin;
        String x$2 = "INVALID_SQLSTATE";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlState"), (Object)sqlState)}));
        return new SqlScriptingException("INVALID_SQLSTATE", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable sqlExceptionOrNotFoundCannotBeCombinedWithOtherConditions(Origin origin) {
        Origin x$1 = origin;
        String x$2 = "INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION";
        Object x$3 = null;
        Map x$4 = Predef$.MODULE$.Map().empty();
        return new SqlScriptingException("INVALID_HANDLER_DECLARATION.INVALID_CONDITION_COMBINATION", null, x$1, (Map<String, String>)x$4);
    }

    public Throwable conditionNotFound(Origin origin, String condition) {
        Origin x$1 = origin;
        String x$2 = "INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND";
        Object x$3 = null;
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"condition"), (Object)condition)}));
        return new SqlScriptingException("INVALID_HANDLER_DECLARATION.CONDITION_NOT_FOUND", null, x$1, (Map<String, String>)x$4);
    }

    private SqlScriptingErrors$() {
    }
}

