/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming.state;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.Path;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.sql.execution.streaming.checkpointing.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.state.RecordType$;
import org.apache.spark.sql.execution.streaming.state.StateStoreChangelogReader;
import org.apache.spark.util.Utils$;
import scala.Enumeration;
import scala.Predef$;
import scala.Tuple3;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00014A\u0001C\u0005\u00011!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011!i\u0003A!A!\u0002\u0013q\u0003\"\u0002\u001b\u0001\t\u0003)\u0004\"\u0002\u001e\u0001\t\u0013Y\u0004\"\u0002(\u0001\t\u0003z\u0005\"B*\u0001\t\u0003\"&aG*uCR,7\u000b^8sK\u000eC\u0017M\\4fY><'+Z1eKJ4&G\u0003\u0002\u000b\u0017\u0005)1\u000f^1uK*\u0011A\"D\u0001\ngR\u0014X-Y7j]\u001eT!AD\b\u0002\u0013\u0015DXmY;uS>t'B\u0001\t\u0012\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003%M\tQa\u001d9be.T!\u0001F\u000b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0012aA8sO\u000e\u00011C\u0001\u0001\u001a!\tQ2$D\u0001\n\u0013\ta\u0012BA\rTi\u0006$Xm\u0015;pe\u0016\u001c\u0005.\u00198hK2|wMU3bI\u0016\u0014\u0018A\u00014n!\ty\"%D\u0001!\u0015\t\t3\"A\u0007dQ\u0016\u001c7\u000e]8j]RLgnZ\u0005\u0003G\u0001\u0012Qc\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'/\u0001\u0006gS2,Gk\u001c*fC\u0012\u0004\"AJ\u0016\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0005\u0019\u001c(B\u0001\u0016\u0014\u0003\u0019A\u0017\rZ8pa&\u0011Af\n\u0002\u0005!\u0006$\b.\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGB\u0011qFM\u0007\u0002a)\u0011\u0011'E\u0001\u0003S>L!a\r\u0019\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0017A\u0002\u001fj]&$h\b\u0006\u00037oaJ\u0004C\u0001\u000e\u0001\u0011\u0015iB\u00011\u0001\u001f\u0011\u0015!C\u00011\u0001&\u0011\u0015iC\u00011\u0001/\u0003-\u0001\u0018M]:f\u0005V4g-\u001a:\u0015\u0005q*\u0005cA\u001fA\u00056\taHC\u0001@\u0003\u0015\u00198-\u00197b\u0013\t\teHA\u0003BeJ\f\u0017\u0010\u0005\u0002>\u0007&\u0011AI\u0010\u0002\u0005\u0005f$X\rC\u0003G\u000b\u0001\u0007q)A\u0003j]B,H\u000f\u0005\u0002I\u00196\t\u0011J\u0003\u00022\u0015*\t1*\u0001\u0003kCZ\f\u0017BA'J\u0005=!\u0015\r^1J]B,Ho\u0015;sK\u0006l\u0017a\u0002<feNLwN\\\u000b\u0002!B\u0011Q(U\u0005\u0003%z\u0012Qa\u00155peR\fqaZ3u\u001d\u0016DH\u000fF\u0001V!\u0015id\u000b\u0017\u001f=\u0013\t9fH\u0001\u0004UkBdWm\r\t\u00033rs!A\u0007.\n\u0005mK\u0011A\u0003*fG>\u0014H\rV=qK&\u0011QL\u0018\u0002\u0006-\u0006dW/Z\u0005\u0003?z\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u0002")
public class StateStoreChangelogReaderV2
extends StateStoreChangelogReader {
    private byte[] parseBuffer(DataInputStream input) {
        int blockSize = input.readInt();
        byte[] blockBuffer = new byte[blockSize];
        Utils$.MODULE$.readFully((InputStream)input, blockBuffer, 0, blockSize);
        return blockBuffer;
    }

    @Override
    public short version() {
        return 2;
    }

    @Override
    public Tuple3<Enumeration.Value, byte[], byte[]> getNext() {
        Enumeration.Value recordType;
        Enumeration.Value value = recordType = RecordType$.MODULE$.getRecordTypeFromByte(this.input().readByte());
        Enumeration.Value value2 = RecordType$.MODULE$.EOF_RECORD();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            this.finished_$eq(true);
            return null;
        }
        Enumeration.Value value3 = recordType;
        Enumeration.Value value4 = RecordType$.MODULE$.PUT_RECORD();
        Enumeration.Value value5 = value3;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.PUT_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        Enumeration.Value value6 = RecordType$.MODULE$.DELETE_RECORD();
        Enumeration.Value value7 = value3;
        if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            int valueSize = this.input().readInt();
            Predef$.MODULE$.assert(valueSize == -1);
            return new Tuple3((Object)RecordType$.MODULE$.DELETE_RECORD(), (Object)keyBuffer, null);
        }
        Enumeration.Value value8 = RecordType$.MODULE$.MERGE_RECORD();
        Enumeration.Value value9 = value3;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            byte[] keyBuffer = this.parseBuffer(this.input());
            byte[] valueBuffer = this.parseBuffer(this.input());
            return new Tuple3((Object)RecordType$.MODULE$.MERGE_RECORD(), (Object)keyBuffer, (Object)valueBuffer);
        }
        throw new IOException("Failed to process unknown record type");
    }

    public StateStoreChangelogReaderV2(CheckpointFileManager fm, Path fileToRead, CompressionCodec compressionCodec) {
        super(fm, fileToRead, compressionCodec);
        this.verifyVersion();
    }
}

