/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import java.util.Map;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hive.service.server.ThreadFactoryWithGarbageCleanup;
import org.apache.spark.internal.SparkLogger;
import org.apache.spark.internal.SparkLoggerFactory;

public class ThreadWithGarbageCleanup
extends Thread {
    private static final SparkLogger LOG = SparkLoggerFactory.getLogger(ThreadWithGarbageCleanup.class);
    Map<Long, RawStore> threadRawStoreMap = ThreadFactoryWithGarbageCleanup.getThreadRawStoreMap();

    public ThreadWithGarbageCleanup(Runnable runnable) {
        super(runnable);
    }

    public void finalize() throws Throwable {
        this.cleanRawStore();
        super.finalize();
    }

    private void cleanRawStore() {
        Long threadId = this.getId();
        RawStore threadLocalRawStore = this.threadRawStoreMap.get(threadId);
        if (threadLocalRawStore != null) {
            LOG.debug("RawStore: " + String.valueOf(threadLocalRawStore) + ", for the thread: " + this.getName() + " will be closed now.");
            threadLocalRawStore.shutdown();
            this.threadRawStoreMap.remove(threadId);
        }
    }

    public void cacheThreadLocalRawStore() {
        Long threadId = this.getId();
        RawStore threadLocalRawStore = HiveMetaStore.HMSHandler.getRawStore();
        if (threadLocalRawStore != null && !this.threadRawStoreMap.containsKey(threadId)) {
            LOG.debug("Adding RawStore: " + String.valueOf(threadLocalRawStore) + ", for the thread: " + this.getName() + " to threadRawStoreMap for future cleanup.");
            this.threadRawStoreMap.put(threadId, threadLocalRawStore);
        }
    }
}

