/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.library.common;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.tez.dag.api.TezUncheckedException;

@InterfaceAudience.Private
public class InputAttemptIdentifier {
    private final int inputIdentifier;
    private final int attemptNumber;
    private final String pathComponent;
    private final boolean shared;
    public static final String PATH_PREFIX = "attempt";
    private final byte fetchTypeInfo;
    private final int spillEventId;

    public InputAttemptIdentifier(int inputIndex, int attemptNumber) {
        this(inputIndex, attemptNumber, null);
    }

    public InputAttemptIdentifier(int inputIdentifier, int attemptNumber, String pathComponent) {
        this(inputIdentifier, attemptNumber, pathComponent, false);
    }

    public InputAttemptIdentifier(int inputIdentifier, int attemptNumber, String pathComponent, boolean shared) {
        this(inputIdentifier, attemptNumber, pathComponent, shared, SPILL_INFO.FINAL_MERGE_ENABLED, -1);
    }

    public InputAttemptIdentifier(int inputIdentifier, int attemptNumber, String pathComponent, boolean shared, SPILL_INFO fetchTypeInfo, int spillEventId) {
        this.inputIdentifier = inputIdentifier;
        this.attemptNumber = attemptNumber;
        this.pathComponent = pathComponent;
        this.shared = shared;
        this.fetchTypeInfo = (byte)fetchTypeInfo.ordinal();
        this.spillEventId = spillEventId;
        if (pathComponent != null && !pathComponent.startsWith(PATH_PREFIX)) {
            throw new TezUncheckedException("Path component must start with: attempt " + this);
        }
    }

    public int getInputIdentifier() {
        return this.inputIdentifier;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public String getPathComponent() {
        return this.pathComponent;
    }

    public boolean isShared() {
        return this.shared;
    }

    public SPILL_INFO getFetchTypeInfo() {
        if (this.fetchTypeInfo == SPILL_INFO.INCREMENTAL_UPDATE.ordinal()) {
            return SPILL_INFO.INCREMENTAL_UPDATE;
        }
        if (this.fetchTypeInfo == SPILL_INFO.FINAL_UPDATE.ordinal()) {
            return SPILL_INFO.FINAL_UPDATE;
        }
        return SPILL_INFO.FINAL_MERGE_ENABLED;
    }

    public int getSpillEventId() {
        return this.spillEventId;
    }

    public boolean canRetrieveInputInChunks() {
        return this.fetchTypeInfo == SPILL_INFO.INCREMENTAL_UPDATE.ordinal() || this.fetchTypeInfo == SPILL_INFO.FINAL_UPDATE.ordinal();
    }

    public boolean includes(InputAttemptIdentifier thatInputAttemptIdentifier) {
        return this.inputIdentifier == thatInputAttemptIdentifier.getInputIdentifier() && this.attemptNumber == thatInputAttemptIdentifier.getAttemptNumber();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attemptNumber;
        result = 31 * result + this.inputIdentifier;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputAttemptIdentifier other = (InputAttemptIdentifier)obj;
        if (this.attemptNumber != other.attemptNumber) {
            return false;
        }
        return this.inputIdentifier == other.inputIdentifier;
    }

    public String toString() {
        return "InputAttemptIdentifier [inputIdentifier=" + this.inputIdentifier + ", attemptNumber=" + this.attemptNumber + ", pathComponent=" + this.pathComponent + ", spillType=" + this.fetchTypeInfo + ", spillId=" + this.spillEventId + "]";
    }

    public static enum SPILL_INFO {
        FINAL_MERGE_ENABLED,
        INCREMENTAL_UPDATE,
        FINAL_UPDATE;

    }
}

