/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.ssl.SslEngineFactoryBase;
import org.asynchttpclient.util.MiscUtils;

public class DefaultSslEngineFactory
extends SslEngineFactoryBase {
    private volatile SslContext sslContext;

    private SslContext buildSslContext(AsyncHttpClientConfig config) throws SSLException {
        if (config.getSslContext() != null) {
            return config.getSslContext();
        }
        SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(config.isUseOpenSsl() ? SslProvider.OPENSSL : SslProvider.JDK).sessionCacheSize((long)config.getSslSessionCacheSize()).sessionTimeout((long)config.getSslSessionTimeout());
        if (MiscUtils.isNonEmpty(config.getEnabledProtocols())) {
            sslContextBuilder.protocols(config.getEnabledProtocols());
        }
        if (MiscUtils.isNonEmpty(config.getEnabledCipherSuites())) {
            sslContextBuilder.ciphers(Arrays.asList(config.getEnabledCipherSuites()));
        } else if (!config.isFilterInsecureCipherSuites()) {
            sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
        }
        if (config.isUseInsecureTrustManager()) {
            sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        return this.configureSslContextBuilder(sslContextBuilder).build();
    }

    @Override
    public SSLEngine newSslEngine(AsyncHttpClientConfig config, String peerHost, int peerPort) {
        SSLEngine sslEngine = config.isDisableHttpsEndpointIdentificationAlgorithm() ? this.sslContext.newEngine(ByteBufAllocator.DEFAULT) : this.sslContext.newEngine(ByteBufAllocator.DEFAULT, this.domain(peerHost), peerPort);
        this.configureSslEngine(sslEngine, config);
        return sslEngine;
    }

    @Override
    public void init(AsyncHttpClientConfig config) throws SSLException {
        this.sslContext = this.buildSslContext(config);
    }

    @Override
    public void destroy() {
        ReferenceCountUtil.release((Object)this.sslContext);
    }

    protected SslContextBuilder configureSslContextBuilder(SslContextBuilder builder) {
        return builder;
    }
}

