/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Time;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStore;
import org.apache.hadoop.yarn.server.timeline.EntityGroupFSTimelineStoreMetrics;
import org.apache.hadoop.yarn.server.timeline.LogInfo;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityCacheItem {
    private static final Logger LOG = LoggerFactory.getLogger(EntityCacheItem.class);
    private TimelineStore store;
    private TimelineEntityGroupId groupId;
    private EntityGroupFSTimelineStore.AppLogs appLogs;
    private long lastRefresh;
    private Configuration config;

    public EntityCacheItem(TimelineEntityGroupId gId, Configuration config) {
        this.groupId = gId;
        this.config = config;
    }

    public synchronized EntityGroupFSTimelineStore.AppLogs getAppLogs() {
        return this.appLogs;
    }

    public synchronized void setAppLogs(EntityGroupFSTimelineStore.AppLogs incomingAppLogs) {
        this.appLogs = incomingAppLogs;
    }

    public synchronized TimelineStore getStore() {
        return this.store;
    }

    public synchronized TimelineStore refreshCache(TimelineACLsManager aclManager, EntityGroupFSTimelineStoreMetrics metrics) throws IOException {
        if (this.needRefresh()) {
            long startTime = Time.monotonicNow();
            if (!this.appLogs.isDone()) {
                this.appLogs.parseSummaryLogs();
            } else if (this.appLogs.getDetailLogs().isEmpty()) {
                this.appLogs.scanForLogs();
            }
            if (!this.appLogs.getDetailLogs().isEmpty()) {
                if (this.store == null) {
                    this.store = (TimelineStore)ReflectionUtils.newInstance((Class)this.config.getClass("yarn.timeline-service.entity-group-fs-store.cache-store-class", MemoryTimelineStore.class, TimelineStore.class), (Configuration)this.config);
                    this.store.init(this.config);
                    this.store.start();
                } else {
                    metrics.incrCacheStaleRefreshes();
                }
                try (TimelineDataManager tdm = new TimelineDataManager(this.store, aclManager);){
                    tdm.init(this.config);
                    tdm.start();
                    this.appLogs.loadDetailLog(tdm, this.groupId);
                }
            }
            this.updateRefreshTimeToNow();
            metrics.addCacheRefreshTime(Time.monotonicNow() - startTime);
        } else {
            LOG.debug("Cache new enough, skip refreshing");
            metrics.incrNoRefreshCacheRead();
        }
        return this.store;
    }

    public synchronized void forceRelease() {
        try {
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (IOException e) {
            LOG.warn("Error closing timeline store", (Throwable)e);
        }
        this.store = null;
        for (LogInfo log : this.appLogs.getDetailLogs()) {
            if (!log.getFilename().contains(this.groupId.toString())) continue;
            log.setOffset(0L);
        }
        LOG.debug("Cache for group {} released. ", (Object)this.groupId);
    }

    private boolean needRefresh() {
        return Time.monotonicNow() - this.lastRefresh > 10000L;
    }

    private void updateRefreshTimeToNow() {
        this.lastRefresh = Time.monotonicNow();
    }
}

