/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.util.ser;

import org.apache.tinkerpop.gremlin.util.MessageSerializer;
import org.apache.tinkerpop.gremlin.util.ser.GraphBinaryMessageSerializerV4;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONMessageSerializerV4;
import org.apache.tinkerpop.gremlin.util.ser.GraphSONUntypedMessageSerializerV4;

public enum Serializers {
    GRAPHSON("application/json"),
    GRAPHSON_V4("application/vnd.gremlin-v4.0+json"),
    GRAPHSON_V4_UNTYPED("application/vnd.gremlin-v4.0+json;types=false"),
    GRAPHBINARY_V4("application/vnd.graphbinary-v4.0");

    private String value;

    private Serializers(String mimeType) {
        this.value = mimeType;
    }

    public String getValue() {
        return this.value;
    }

    public MessageSerializer<?> simpleInstance() {
        switch (this.value) {
            case "application/json": 
            case "application/vnd.gremlin-v4.0+json": {
                return new GraphSONMessageSerializerV4();
            }
            case "application/vnd.gremlin-v4.0+json;types=false": {
                return new GraphSONUntypedMessageSerializerV4();
            }
            case "application/vnd.graphbinary-v4.0": {
                return new GraphBinaryMessageSerializerV4();
            }
        }
        throw new RuntimeException("Could not create a simple MessageSerializer instance of " + this.value);
    }
}

