/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.ui;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.TagHandlerImpl;
import com.sun.faces.util.FacesLogger;
import jakarta.el.VariableMapper;
import jakarta.faces.component.UIComponent;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.TagAttribute;
import jakarta.faces.view.facelets.TagAttributeException;
import jakarta.faces.view.facelets.TagConfig;
import jakarta.faces.view.facelets.TagException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class IncludeHandler
extends TagHandlerImpl {
    private static final Logger log = FacesLogger.FACELETS_INCLUDE.getLogger();
    private final TagAttribute src;

    public IncludeHandler(TagConfig config) {
        super(config);
        TagAttribute attr = null;
        attr = this.getAttribute("src");
        if (null == attr) {
            attr = this.getAttribute("file");
        }
        if (null == attr) {
            attr = this.getAttribute("page");
        }
        if (null == attr) {
            throw new TagException(this.tag, "Attribute 'src', 'file' or 'page' is required");
        }
        this.src = attr;
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String path = this.src.getValue(ctx);
        if (path == null || path.length() == 0) {
            return;
        }
        VariableMapper orig = ctx.getVariableMapper();
        ctx.setVariableMapper(new VariableMapperWrapper(orig));
        try {
            this.nextHandler.apply(ctx, null);
            ctx.includeFacelet(parent, path);
        }
        catch (IOException e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, e.toString(), e);
            }
            throw new TagAttributeException(this.tag, this.src, "Invalid path : " + path, e);
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

