/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.SharedMetricRegistries;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.annotation.RegistryScope;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricRegistryProducer {
    @Produces
    @Default
    @RegistryScope
    public MetricRegistry getMetricRegistry(InjectionPoint ip) {
        RegistryScope registryScopeAnnotation = (RegistryScope)ip.getAnnotated().getAnnotation(RegistryScope.class);
        return SharedMetricRegistries.getOrCreate(registryScopeAnnotation == null ? "application" : registryScopeAnnotation.scope());
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    public MetricRegistry getApplicationRegistry() {
        return SharedMetricRegistries.getOrCreate("application");
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.BASE)
    public MetricRegistry getBaseRegistry() {
        return SharedMetricRegistries.getOrCreate("base");
    }

    @Produces
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    public MetricRegistry getVendorRegistry() {
        return SharedMetricRegistries.getOrCreate("vendor");
    }
}

