/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.function.Supplier;
import org.apache.tomee.microprofile.health.MicroProfileHealthReporter;

@Path(value="health")
@ApplicationScoped
public class MicroProfileHealthChecksEndpoint {
    @Inject
    private MicroProfileHealthReporter reporter;

    @GET
    @Produces(value={"application/json"})
    public Response getChecks() {
        return this.toResponse(this.reporter::getHealth);
    }

    @GET
    @Path(value="live")
    @Produces(value={"application/json"})
    public Response getLiveChecks() {
        return this.toResponse(this.reporter::getLiveness);
    }

    @GET
    @Path(value="ready")
    @Produces(value={"application/json"})
    public Response getReadyChecks() {
        return this.toResponse(this.reporter::getReadiness);
    }

    @GET
    @Path(value="started")
    @Produces(value={"application/json"})
    public Response getStartedChecks() {
        return this.toResponse(this.reporter::getStartup);
    }

    private Response toResponse(Supplier<SmallRyeHealth> health) {
        return Response.status((Response.Status)(health.get().isDown() ? Response.Status.SERVICE_UNAVAILABLE : Response.Status.OK)).entity((Object)health.get().getPayload()).build();
    }
}

