/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.media;

import io.smallrye.openapi.api.models.media.EncodingImpl;
import io.smallrye.openapi.runtime.io.IOContext;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.MapModelIO;
import io.smallrye.openapi.runtime.io.Names;
import io.smallrye.openapi.runtime.io.extensions.ExtensionIO;
import io.smallrye.openapi.runtime.io.headers.HeaderIO;
import io.smallrye.openapi.runtime.io.media.ContentIO;
import java.util.Arrays;
import java.util.Optional;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.media.Encoding;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class EncodingIO<V, A extends V, O extends V, AB, OB>
extends MapModelIO<Encoding, V, A, O, AB, OB> {
    private static final String PROP_ALLOW_RESERVED = "allowReserved";
    private static final String PROP_CONTENT_TYPE = "contentType";
    private static final String PROP_HEADERS = "headers";
    private static final String PROP_EXPLODE = "explode";
    private static final String PROP_STYLE = "style";
    private final HeaderIO<V, A, O, AB, OB> headerIO;
    private final ExtensionIO<V, A, O, AB, OB> extensionIO;

    public EncodingIO(IOContext<V, A, O, AB, OB> context, ContentIO<V, A, O, AB, OB> contentIO, ExtensionIO<V, A, O, AB, OB> extensionIO) {
        super(context, Names.ENCODING, Names.create(Encoding.class));
        this.headerIO = new HeaderIO<V, A, O, AB, OB>(context, contentIO, extensionIO);
        this.extensionIO = extensionIO;
    }

    @Override
    public Encoding read(AnnotationInstance annotation) {
        IoLogging.logger.singleAnnotation("@Encoding");
        EncodingImpl encoding = new EncodingImpl();
        encoding.setContentType((String)this.value(annotation, PROP_CONTENT_TYPE));
        encoding.setStyle(this.readStyle(annotation));
        encoding.setExplode((Boolean)this.value(annotation, PROP_EXPLODE));
        encoding.setAllowReserved((Boolean)this.value(annotation, PROP_ALLOW_RESERVED));
        encoding.setHeaders(this.headerIO.readMap(annotation.value(PROP_HEADERS)));
        encoding.setExtensions(this.extensionIO.readExtensible(annotation));
        return encoding;
    }

    @Override
    public Encoding readObject(O node) {
        IoLogging.logger.singleJsonNode("Encoding");
        EncodingImpl encoding = new EncodingImpl();
        encoding.setContentType(this.jsonIO().getString(node, PROP_CONTENT_TYPE));
        encoding.setHeaders(this.headerIO.readMap(this.jsonIO().getValue(node, PROP_HEADERS)));
        encoding.setStyle(this.readStyle(this.jsonIO().getValue(node, PROP_STYLE)));
        encoding.setExplode(this.jsonIO().getBoolean(node, PROP_EXPLODE));
        encoding.setAllowReserved(this.jsonIO().getBoolean(node, PROP_ALLOW_RESERVED));
        encoding.setExtensions(this.extensionIO.readMap(node));
        return encoding;
    }

    @Override
    public Optional<O> write(Encoding model) {
        return this.optionalJsonObject(model).map(node -> {
            this.setIfPresent(node, PROP_CONTENT_TYPE, this.jsonIO().toJson(model.getContentType()));
            this.setIfPresent(node, PROP_HEADERS, this.headerIO.write(model.getHeaders()));
            this.setIfPresent(node, PROP_STYLE, this.jsonIO().toJson(model.getStyle()));
            this.setIfPresent(node, PROP_EXPLODE, this.jsonIO().toJson(model.getExplode()));
            this.setIfPresent(node, PROP_ALLOW_RESERVED, this.jsonIO().toJson(model.getAllowReserved()));
            this.setAllIfPresent(node, this.extensionIO.write((Extensible<?>)model));
            return node;
        }).map(this.jsonIO()::buildObject);
    }

    Encoding.Style readStyle(AnnotationInstance annotation) {
        return Optional.ofNullable(annotation).map(a -> a.value(PROP_STYLE)).map(AnnotationValue::asString).flatMap(this::readStyle).orElse(null);
    }

    private Encoding.Style readStyle(V node) {
        return Optional.ofNullable(node).map(this.jsonIO()::asString).flatMap(this::readStyle).orElse(null);
    }

    private Optional<Encoding.Style> readStyle(String style) {
        return Arrays.stream(Encoding.Style.values()).filter(value -> style.equals(value.toString())).findFirst();
    }
}

