/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAVLDiskLarge;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.DataSpaceManager;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TableSpaceManager;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDisk
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;
    boolean largeData;

    public RowStoreAVLDisk(DataFileCache dataFileCache, Table table) {
        this.table = table;
        this.database = table.database;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        this.cache = dataFileCache;
        this.rowOut = dataFileCache.rowOut.duplicate();
        this.largeData = this.database.logger.getDataFileFactor() > 1;
        dataFileCache.adjustStoreCount(1);
        this.rowActionMap = new LongKeyHashMap(8);
        this.largeData = this.database.logger.propLargeData;
        this.tableSpace = dataFileCache.spaceManager.getTableSpace(table.getSpaceID());
        this.lock = new ReentrantReadWriteLock(true);
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    private void set(CachedObject cachedObject) {
        RowAction rowAction;
        if (this.database.txManager.isMVRows() && (rowAction = (RowAction)this.rowActionMap.get(cachedObject.getPos())) != null) {
            ((Row)cachedObject).rowAction = rowAction;
        }
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, bl);
        return cachedObject;
    }

    public CachedObject get(long l) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, false);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        int n = cachedObject.getRealSize(this.rowOut);
        n += this.indexList.length * 16;
        n = this.rowOut.getStorageSize(n);
        cachedObject.setStorageSize(n);
        long l = this.tableSpace.getFilePosition(n);
        cachedObject.setPos(l);
        if (bl) {
            RowAction rowAction = RowAction.addInsertAction(session, this.table, this, (Row)cachedObject);
            if (this.database.txManager.isMVRows()) {
                this.rowActionMap.put(cachedObject.getPos(), rowAction);
            }
        }
        this.cache.add(cachedObject, false);
        this.storageSize += (long)n;
    }

    @Override
    public boolean canRead(Session session, long l, int n, int[] nArray) {
        if (this.database.txManager.isMVRows()) {
            RowAction rowAction = (RowAction)this.rowActionMap.get(l);
            if (rowAction == null) {
                return true;
            }
            return rowAction.canRead(session, n, nArray);
        }
        return true;
    }

    @Override
    public boolean canRead(Session session, CachedObject cachedObject, int n, int[] nArray) {
        RowAction rowAction = ((Row)cachedObject).rowAction;
        if (rowAction == null) {
            return true;
        }
        return rowAction.canRead(session, n, nArray);
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        RowAVLDisk rowAVLDisk = this.largeData ? new RowAVLDiskLarge(this, rowInputInterface) : new RowAVLDisk(this, rowInputInterface);
        this.set(rowAVLDisk);
        return rowAVLDisk;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDisk rowAVLDisk = this.largeData ? new RowAVLDiskLarge(this.table, (Object[])object, this) : new RowAVLDisk(this.table, (Object[])object, this);
        this.add(session, rowAVLDisk, bl);
        return rowAVLDisk;
    }

    @Override
    public void delete(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.delete(session, row);
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void removeAll() {
        if (this.cache.spaceManager.isMultiSpace()) {
            if (this.tableSpace.isDefaultSpace()) {
                DoubleLongIndex doubleLongIndex = this.getPointerList();
                this.removeDefaultSpaces(doubleLongIndex);
            } else {
                this.cache.spaceManager.freeTableSpace(this.tableSpace.getSpaceID());
            }
        }
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject cachedObject) {
        this.cache.remove(cachedObject);
        this.tableSpace.release(cachedObject.getPos(), cachedObject.getStorageSize());
        this.storageSize -= (long)cachedObject.getStorageSize();
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
        if (rowAction.getType() == 0) {
            Lock lock = this.rowActionMap.getWriteLock();
            lock.lock();
            try {
                if (rowAction.getType() != 0) return;
                this.rowActionMap.remove(rowAction.getPos());
                return;
            }
            finally {
                lock.unlock();
            }
        } else {
            if (rowAction.getType() != 3 || rowAction.isDeleteComplete()) return;
            rowAction.setDeleteComplete();
            Row row = rowAction.getRow();
            this.delete(session, row);
            this.rowActionMap.remove(row.getPos());
            this.remove(row);
        }
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        Object[] objectArray = row.getData();
        switch (n) {
            case 2: {
                this.database.logger.writeDeleteStatement(session, (Table)this.table, objectArray);
                if (n2 != 0) break;
                this.remove(row);
                break;
            }
            case 1: {
                this.database.logger.writeInsertStatement(session, row, (Table)this.table);
                break;
            }
            case 4: {
                if (n2 != 0) break;
                this.remove(row);
                break;
            }
            case 3: {
                this.delete(session, row);
                if (this.database.txManager.isMVRows()) {
                    this.rowActionMap.remove(row.getPos());
                }
                this.remove(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 == 0) {
                    row = (Row)this.get((CachedObject)row, true);
                    ((RowAVL)row).setNewNodes(this);
                    row.keepInMemory(false);
                    this.indexRow(session, row);
                    break;
                }
                RowAction rowAction = row.getAction();
                if (rowAction.getType() != 0) break;
                this.rowActionMap.remove(row.getPos());
                break;
            }
            case 1: {
                this.delete(session, row);
                if (this.database.txManager.isMVRows()) {
                    this.rowActionMap.remove(row.getPos());
                }
                this.remove(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.rowActionMap.remove(row.getPos());
                this.remove(row);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowAction addDeleteActionToRow(Session session, Row row, int[] nArray, boolean bl) {
        RowAction rowAction = null;
        if (!bl) {
            Row row2 = row;
            synchronized (row2) {
                return RowAction.addDeleteAction(session, this.table, this, row, nArray);
            }
        }
        row = (Row)this.cache.get(row, (PersistentStore)this, true);
        Lock lock = this.rowActionMap.getWriteLock();
        lock.lock();
        try {
            rowAction = RowAction.addDeleteAction(session, this.table, this, row, nArray);
            if (rowAction != null) {
                this.rowActionMap.put(rowAction.getPos(), rowAction);
            }
        }
        finally {
            lock.unlock();
            row.keepInMemory(false);
        }
        return rowAction;
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void release() {
        this.cache.adjustStoreCount(-1);
        this.cache = null;
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVLDisk");
        }
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[n];
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = (RowAVL)this.get((CachedObject)nodeAVL.getRow(this), false);
        nodeAVL = rowAVL.getNode(index.getPosition());
        this.accessorList[index.getPosition()] = nodeAVL;
        return nodeAVL;
    }

    @Override
    public void setAccessors(long l, long[] lArray, long l2) {
        for (int i = 0; i < this.indexList.length; ++i) {
            this.setAccessor(this.indexList[i], lArray[i]);
        }
        this.setElementCount(l2);
    }

    @Override
    public void setAccessor(Index index, long l) {
        CachedObject cachedObject = this.get(l, false);
        if (cachedObject != null) {
            NodeAVL nodeAVL = ((RowAVL)cachedObject).getNode(index.getPosition());
            cachedObject = nodeAVL;
        }
        this.setAccessor(index, cachedObject);
    }

    @Override
    public void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        throw Error.runtimeError(201, "RowStoreAVLDisk");
    }

    @Override
    public void setReadOnly(boolean bl) {
    }

    public void setSpaceManager(Session session) {
        if (this.table.getSpaceID() == 7) {
            return;
        }
        TableSpaceManager tableSpaceManager = this.cache.spaceManager.getTableSpace(this.table.getSpaceID());
        this.setSpaceManager(tableSpaceManager);
        this.moveDataToSpace(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveDataToSpace(Session session) {
        Table table = (Table)this.table;
        long l = this.elementCount();
        if (l == 0L) {
            return;
        }
        if (l > Integer.MAX_VALUE) {
            return;
        }
        this.writeLock();
        try {
            DoubleLongIndex doubleLongIndex = this.getPointerList();
            LongLookup longLookup = doubleLongIndex.duplicate();
            this.moveDataToNewSpace(this.cache, doubleLongIndex);
            CachedObject[] cachedObjectArray = new CachedObject[this.accessorList.length];
            for (int i = 0; i < this.accessorList.length; ++i) {
                Index index = this.indexList[i];
                long l2 = doubleLongIndex.lookup(this.accessorList[i].getPos());
                RowAVL rowAVL = (RowAVL)this.cache.get(l2, (PersistentStore)this, false);
                NodeAVL nodeAVL = rowAVL.getNode(index.getPosition());
                cachedObjectArray[index.getPosition()] = nodeAVL;
            }
            this.removeDefaultSpaces(longLookup);
            this.accessorList = cachedObjectArray;
        }
        finally {
            this.writeUnlock();
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
    }

    public void moveDataToSpace(DataFileCache dataFileCache, LongLookup longLookup) {
        this.populatePointerList(longLookup);
        this.moveDataToNewSpace(dataFileCache, longLookup);
    }

    private DoubleLongIndex getPointerList() {
        DoubleLongIndex doubleLongIndex = new DoubleLongIndex((int)this.elementCount());
        this.populatePointerList(doubleLongIndex);
        return doubleLongIndex;
    }

    private void populatePointerList(LongLookup longLookup) {
        RowIterator rowIterator = this.indexList[0].firstRow(this);
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            longLookup.addUnsorted(row.getPos(), row.getStorageSize());
        }
        longLookup.sort();
    }

    private void moveDataToNewSpace(DataFileCache dataFileCache, LongLookup longLookup) {
        int n = this.table.getSpaceID();
        TableSpaceManager tableSpaceManager = dataFileCache.spaceManager.getTableSpace(n);
        for (int i = 0; i < longLookup.size(); ++i) {
            long l = tableSpaceManager.getFilePosition((int)longLookup.getLongValue(i));
            longLookup.setLongValue(i, l);
        }
        RowIterator rowIterator = this.indexList[0].firstRow(this);
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            long l = longLookup.lookup(row.getPos());
            dataFileCache.rowOut.reset();
            row.write(dataFileCache.rowOut, longLookup);
            dataFileCache.saveRowOutput(l);
        }
    }

    private void removeDefaultSpaces(LongLookup longLookup) {
        DataSpaceManager dataSpaceManager = this.cache.spaceManager;
        int n = this.cache.getDataFileScale();
        for (int i = 0; i < longLookup.size(); ++i) {
            long l = longLookup.getLongKey(i);
            long l2 = longLookup.getLongValue(i) / (long)n;
            longLookup.setLongValue(i, l2);
            this.cache.release(l);
        }
        longLookup.compactLookupAsIntervals();
        dataSpaceManager.freeTableSpace(7, longLookup, 0L, 0L);
    }

    long getStorageSizeEstimate() {
        if (this.elementCount.get() == 0L) {
            return 0L;
        }
        CachedObject cachedObject = this.getAccessor(this.indexList[0]);
        CachedObject cachedObject2 = this.get(cachedObject.getPos(), false);
        return (long)cachedObject2.getStorageSize() * this.elementCount.get();
    }

    @Override
    public void readLock() {
        this.readLock.lock();
    }

    @Override
    public void readUnlock() {
        this.readLock.unlock();
    }

    @Override
    public void writeLock() {
        this.writeLock.lock();
    }

    @Override
    public void writeUnlock() {
        this.writeLock.unlock();
    }
}

