/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.util;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.util.AnnotationLiteral;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import org.apache.myfaces.cdi.util.AnyLiteral;
import org.apache.myfaces.cdi.util.DefaultLiteral;

public abstract class AbstractDynamicProducer<T>
implements Bean<T>,
PassivationCapable,
Serializable {
    private BeanManager beanManager;
    private String id;
    private String name;
    private Class<?> beanClass;
    private Set<Type> types;
    private Set<Annotation> qualifiers;
    private Class<? extends Annotation> scope;
    private Function<CreationalContext<T>, T> create;

    public AbstractDynamicProducer(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.id = this.getClass().getName();
        this.beanClass = Object.class;
        this.types = Collections.singleton(Object.class);
        this.qualifiers = Collections.unmodifiableSet(AbstractDynamicProducer.asSet(new AnnotationLiteral[]{new DefaultLiteral(), new AnyLiteral()}));
        this.scope = Dependent.class;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public T create(CreationalContext<T> creationalContext) {
        return this.create.apply(creationalContext);
    }

    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public AbstractDynamicProducer<T> name(String name) {
        this.name = name;
        return this;
    }

    public AbstractDynamicProducer<T> create(Function<CreationalContext<T>, T> create) {
        this.create = create;
        return this;
    }

    public AbstractDynamicProducer<T> beanClass(Class<?> beanClass) {
        this.beanClass = beanClass;
        return this;
    }

    public AbstractDynamicProducer<T> types(Type ... types) {
        this.types = AbstractDynamicProducer.asSet(types);
        return this;
    }

    public AbstractDynamicProducer<T> beanClassAndType(Class<?> beanClass) {
        this.beanClass(beanClass);
        this.types(beanClass);
        return this;
    }

    public AbstractDynamicProducer<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = AbstractDynamicProducer.asSet(qualifiers);
        return this;
    }

    public AbstractDynamicProducer<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    public AbstractDynamicProducer<T> id(String id) {
        this.id = id;
        return this;
    }

    public AbstractDynamicProducer<T> addToId(Object object) {
        this.id = this.id + " " + object.toString();
        return this;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }
}

