/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.component.html.HtmlCommandScript;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.FacesEvent;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.core.api.shared.ComponentUtils;
import org.apache.myfaces.core.api.shared.lang.SharedStringBuilder;
import org.apache.myfaces.renderkit.html.base.HtmlRenderer;
import org.apache.myfaces.renderkit.html.util.AjaxScriptBuilder;
import org.apache.myfaces.renderkit.html.util.ClientBehaviorRendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.JavascriptContext;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;
import org.apache.myfaces.util.lang.StringUtils;

public class HtmlCommandScriptRenderer
extends HtmlRenderer {
    private static final String AJAX_SB = "oam.renderkit.AJAX_SB";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        super.encodeBegin(context, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        ResponseWriter writer = context.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(context, writer);
        writer.startElement("span", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.startElement("script", component);
        HtmlRendererUtils.renderScriptType(context, writer);
        JavascriptContext script = new JavascriptContext();
        String cmdName = commandScript.getName();
        String name = cmdName != null && cmdName.length() > 0 ? JavascriptUtils.getValidJavascriptName(cmdName, true) : JavascriptUtils.getValidJavascriptName(component.getClientId(context), true);
        script.prettyLine();
        script.increaseIndent();
        script.append("var " + name + " = function(o){var o=(typeof o==='object')&&o?o:{};");
        script.prettyLine();
        List<UIParameter> uiParams = HtmlRendererUtils.getValidUIParameterChildren(context, this.getChildren((UIComponent)commandScript), false, false);
        StringBuilder ajax = SharedStringBuilder.get((FacesContext)context, (String)AJAX_SB, (int)60);
        AjaxScriptBuilder.build(context, ajax, (UIComponent)commandScript, commandScript.getClientId(context), "action", commandScript.getExecute(), commandScript.getRender(), commandScript.getResetValues(), commandScript.getOnerror(), commandScript.getOnevent(), uiParams, "o");
        script.append(ajax.toString());
        script.decreaseIndent();
        script.append("}");
        if (commandScript.isAutorun()) {
            script.append(";");
            script.append("myfaces.onDomReady(");
            script.append(name);
            script.append(");");
        }
        writer.writeText((Object)script.toString(), null);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        super.encodeEnd(context, component);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
        writer.endElement("span");
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        HtmlCommandScript commandScript = (HtmlCommandScript)component;
        if (HtmlRendererUtils.isDisabled(component) || !commandScript.isRendered()) {
            return;
        }
        Map paramMap = facesContext.getExternalContext().getRequestParameterMap();
        String behaviorEventName = (String)paramMap.get("jakarta.faces.behavior.event");
        if (behaviorEventName != null) {
            String item;
            String sourceId = (String)paramMap.get("jakarta.faces.source");
            String componentClientId = component.getClientId(facesContext);
            String clientId = sourceId;
            if (sourceId.startsWith(componentClientId) && sourceId.length() > componentClientId.length() && StringUtils.isInteger(item = sourceId.substring(componentClientId.length() + 1))) {
                clientId = componentClientId;
            }
            if (component.getClientId(facesContext).equals(clientId)) {
                boolean disabled = HtmlRendererUtils.isDisabled(component);
                UIForm form = (UIForm)ComponentUtils.findClosest(UIForm.class, (UIComponent)component);
                boolean activateActionEvent = false;
                if (form != null && !disabled) {
                    String reqValue = (String)facesContext.getExternalContext().getRequestParameterMap().get(HtmlRendererUtils.getHiddenCommandLinkFieldName((UIComponent)form, facesContext));
                    boolean bl = activateActionEvent = reqValue != null && reqValue.equals(clientId) || HtmlRendererUtils.isPartialOrBehaviorSubmit(facesContext, clientId);
                }
                if (activateActionEvent) {
                    component.queueEvent((FacesEvent)new ActionEvent(component));
                }
            }
        }
        if (component instanceof ClientBehaviorHolder && !HtmlRendererUtils.isDisabled(component)) {
            ClientBehaviorRendererUtils.decodeClientBehaviors(facesContext, component);
        }
    }
}

