/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.factory;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.uniffle.client.api.CoordinatorClient;
import org.apache.uniffle.client.impl.grpc.CoordinatorGrpcClient;
import org.apache.uniffle.com.google.common.collect.Lists;
import org.apache.uniffle.common.ClientType;
import org.apache.uniffle.common.exception.RssException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinatorClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CoordinatorClientFactory.class);
    private ClientType clientType;

    public CoordinatorClientFactory(ClientType clientType) {
        this.clientType = clientType;
    }

    public CoordinatorClient createCoordinatorClient(String host, int port) {
        if (this.clientType.equals((Object)ClientType.GRPC) || this.clientType.equals((Object)ClientType.GRPC_NETTY)) {
            return new CoordinatorGrpcClient(host, port);
        }
        throw new UnsupportedOperationException("Unsupported client type " + (Object)((Object)this.clientType));
    }

    public List<CoordinatorClient> createCoordinatorClient(String coordinators) {
        LOG.info("Start to create coordinator clients from {}", (Object)coordinators);
        LinkedList<CoordinatorClient> coordinatorClients = Lists.newLinkedList();
        String[] coordinatorList = coordinators.trim().split(",");
        if (coordinatorList.length == 0) {
            String msg = "Invalid " + coordinators;
            LOG.error(msg);
            throw new RssException(msg);
        }
        for (String coordinator : coordinatorList) {
            Object[] ipPort = coordinator.trim().split(":");
            if (ipPort.length != 2) {
                String msg = "Invalid coordinator format " + Arrays.toString(ipPort);
                LOG.error(msg);
                throw new RssException(msg);
            }
            String host = ipPort[0];
            int port = Integer.parseInt((String)ipPort[1]);
            CoordinatorClient coordinatorClient = this.createCoordinatorClient(host, port);
            coordinatorClients.add(coordinatorClient);
            LOG.info("Add coordinator client {}", (Object)coordinatorClient.getDesc());
        }
        LOG.info("Finish create coordinator clients {}", (Object)coordinatorClients.stream().map(CoordinatorClient::getDesc).collect(Collectors.joining(", ")));
        return coordinatorClients;
    }
}

