/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.PushGateway;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.exception.RssException;
import org.apache.uniffle.common.metrics.AbstractMetricReporter;
import org.apache.uniffle.common.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusPushGatewayMetricReporter
extends AbstractMetricReporter {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusPushGatewayMetricReporter.class);
    static final String PUSHGATEWAY_ADDR = "rss.metrics.prometheus.pushgateway.addr";
    static final String GROUPING_KEY = "rss.metrics.prometheus.pushgateway.groupingkey";
    static final String JOB_NAME = "rss.metrics.prometheus.pushgateway.jobname";
    static final String REPORT_INTEVAL = "rss.metrics.prometheus.pushgateway.report.interval.seconds";
    private ScheduledExecutorService scheduledExecutorService;
    private PushGateway pushGateway;

    public PrometheusPushGatewayMetricReporter(RssConf conf, String instanceId) {
        super(conf, instanceId);
    }

    @Override
    public void start() {
        String jobName;
        if (this.pushGateway == null) {
            String address = this.conf.getString(PUSHGATEWAY_ADDR, null);
            if (StringUtils.isEmpty((CharSequence)address)) {
                throw new RssException("rss.metrics.prometheus.pushgateway.addr should not be empty!");
            }
            this.pushGateway = new PushGateway(address);
        }
        if (StringUtils.isEmpty((CharSequence)(jobName = this.conf.getString(JOB_NAME, null)))) {
            throw new RssException("rss.metrics.prometheus.pushgateway.jobname should not be empty!");
        }
        Map<String, String> groupingKey = PrometheusPushGatewayMetricReporter.parseGroupingKey(this.conf.getString(GROUPING_KEY, ""));
        groupingKey.put("instance", this.instanceId);
        int reportInterval = this.conf.getInteger(REPORT_INTEVAL, 10);
        this.scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor("PrometheusPushGatewayMetricReporter");
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            for (CollectorRegistry registry : this.registryList) {
                try {
                    this.pushGateway.pushAdd(registry, jobName, groupingKey);
                }
                catch (Throwable e) {
                    LOG.error("Failed to send metrics to push gateway.", e);
                }
            }
        }, 0L, reportInterval, TimeUnit.SECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
        }
    }

    @VisibleForTesting
    void setPushGateway(PushGateway pushGateway) {
        this.pushGateway = pushGateway;
    }

    static Map<String, String> parseGroupingKey(String groupingKeyConfig) {
        HashMap<String, String> groupingKey = new HashMap<String, String>();
        if (!groupingKeyConfig.isEmpty()) {
            String[] kvs;
            for (String kv : kvs = groupingKeyConfig.split(";")) {
                int idx = kv.indexOf("=");
                if (idx < 0) {
                    LOG.warn("Invalid prometheusPushGateway groupingKey:{}, will be ignored", (Object)kv);
                    continue;
                }
                String labelKey = kv.substring(0, idx);
                String labelValue = kv.substring(idx + 1);
                if (StringUtils.isEmpty((CharSequence)labelKey) || StringUtils.isEmpty((CharSequence)labelValue)) {
                    LOG.warn("Invalid groupingKey {labelKey:{}, labelValue:{}} must not be empty", (Object)labelKey, (Object)labelValue);
                    continue;
                }
                groupingKey.put(labelKey, labelValue);
            }
            return groupingKey;
        }
        return groupingKey;
    }
}

