/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.netty.protocol;

import org.apache.uniffle.common.netty.buffer.FileSegmentManagedBuffer;
import org.apache.uniffle.common.netty.buffer.ManagedBuffer;
import org.apache.uniffle.common.netty.buffer.NettyManagedBuffer;
import org.apache.uniffle.common.netty.protocol.Message;
import org.apache.uniffle.common.netty.protocol.RpcResponse;
import org.apache.uniffle.common.netty.protocol.Transferable;
import org.apache.uniffle.common.rpc.StatusCode;
import org.apache.uniffle.common.util.ByteBufUtils;
import org.apache.uniffle.io.netty.buffer.ByteBuf;
import org.apache.uniffle.io.netty.buffer.Unpooled;
import org.apache.uniffle.io.netty.channel.Channel;

public class GetLocalShuffleIndexResponse
extends RpcResponse
implements Transferable {
    private ManagedBuffer buffer;
    private long fileLength;

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, byte[] indexData, long fileLength) {
        this(requestId, statusCode, retMessage, indexData == null ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer(indexData), fileLength);
    }

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, ByteBuf indexData, long fileLength) {
        this(requestId, statusCode, retMessage, new NettyManagedBuffer(indexData), fileLength);
    }

    public GetLocalShuffleIndexResponse(long requestId, StatusCode statusCode, String retMessage, ManagedBuffer indexData, long fileLength) {
        super(requestId, statusCode, retMessage);
        this.buffer = indexData;
        this.fileLength = fileLength;
    }

    @Override
    public int encodedLength() {
        return super.encodedLength() + 4 + this.buffer.size() + 8;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        if (this.buffer instanceof FileSegmentManagedBuffer) {
            buf.writeInt(this.buffer.size());
        } else {
            ByteBufUtils.copyByteBuf(this.buffer.byteBuf(), buf);
            this.buffer.release();
        }
        buf.writeLong(this.fileLength);
    }

    public static GetLocalShuffleIndexResponse decode(ByteBuf byteBuf) {
        long requestId = byteBuf.readLong();
        StatusCode statusCode = StatusCode.fromCode(byteBuf.readInt());
        String retMessage = ByteBufUtils.readLengthAndString(byteBuf);
        ByteBuf indexData = ByteBufUtils.readSlice(byteBuf);
        long fileLength = byteBuf.readLong();
        return new GetLocalShuffleIndexResponse(requestId, statusCode, retMessage, indexData, fileLength);
    }

    @Override
    public Message.Type type() {
        return Message.Type.GET_LOCAL_SHUFFLE_INDEX_RESPONSE;
    }

    public ByteBuf getIndexData() {
        return this.buffer.byteBuf();
    }

    public long getFileLength() {
        return this.fileLength;
    }

    @Override
    public void transferTo(Channel channel) {
        channel.write(this.buffer.convertToNetty());
        this.buffer.release();
    }
}

