/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.client.request;

import java.util.List;
import org.apache.uniffle.common.PartitionRange;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.common.ShuffleDataDistributionType;
import org.apache.uniffle.common.config.RssClientConf;

public class RssRegisterShuffleRequest {
    private String appId;
    private int shuffleId;
    private List<PartitionRange> partitionRanges;
    private RemoteStorageInfo remoteStorageInfo;
    private String user;
    private ShuffleDataDistributionType dataDistributionType;
    private int maxConcurrencyPerPartitionToWrite;

    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType, int maxConcurrencyPerPartitionToWrite) {
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.partitionRanges = partitionRanges;
        this.remoteStorageInfo = remoteStorageInfo;
        this.user = user;
        this.dataDistributionType = dataDistributionType;
        this.maxConcurrencyPerPartitionToWrite = maxConcurrencyPerPartitionToWrite;
    }

    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, RemoteStorageInfo remoteStorageInfo, String user, ShuffleDataDistributionType dataDistributionType) {
        this(appId, shuffleId, partitionRanges, remoteStorageInfo, user, dataDistributionType, (Integer)RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE.defaultValue());
    }

    public RssRegisterShuffleRequest(String appId, int shuffleId, List<PartitionRange> partitionRanges, String remoteStoragePath) {
        this(appId, shuffleId, partitionRanges, new RemoteStorageInfo(remoteStoragePath), "", ShuffleDataDistributionType.NORMAL, (Integer)RssClientConf.MAX_CONCURRENCY_PER_PARTITION_TO_WRITE.defaultValue());
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public List<PartitionRange> getPartitionRanges() {
        return this.partitionRanges;
    }

    public RemoteStorageInfo getRemoteStorageInfo() {
        return this.remoteStorageInfo;
    }

    public String getUser() {
        return this.user;
    }

    public ShuffleDataDistributionType getDataDistributionType() {
        return this.dataDistributionType;
    }

    public int getMaxConcurrencyPerPartitionToWrite() {
        return this.maxConcurrencyPerPartitionToWrite;
    }
}

