/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.uniffle.common.config.FallbackKey;

public class ConfigOption<T> {
    static final FallbackKey[] EMPTY = new FallbackKey[0];
    static final String EMPTY_DESCRIPTION = "";
    private final String key;
    private final T defaultValue;
    private final String description;
    private final Class<?> clazz;
    private final Function<Object, T> converter;
    private final FallbackKey[] fallbackKeys;

    ConfigOption(String key, Class<?> clazz, String description, T defaultValue, Function<Object, T> converter, FallbackKey ... fallbackKeys) {
        this.key = Objects.requireNonNull(key);
        this.description = description;
        this.defaultValue = defaultValue;
        this.clazz = Objects.requireNonNull(clazz);
        this.converter = Objects.requireNonNull(converter);
        this.fallbackKeys = fallbackKeys == null || fallbackKeys.length == 0 ? EMPTY : fallbackKeys;
    }

    public ConfigOption<T> withDescription(String description) {
        return new ConfigOption<T>(this.key, this.clazz, description, this.defaultValue, this.converter, new FallbackKey[0]);
    }

    public ConfigOption<T> withFallbackKeys(String ... fallbackKeys) {
        Stream<FallbackKey> newFallbackKeys = Arrays.stream(fallbackKeys).map(FallbackKey::createFallbackKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(newFallbackKeys, currentAlternativeKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.clazz, this.description, this.defaultValue, this.converter, mergedAlternativeKeys);
    }

    public ConfigOption<T> withDeprecatedKeys(String ... deprecatedKeys) {
        Stream<FallbackKey> newDeprecatedKeys = Arrays.stream(deprecatedKeys).map(FallbackKey::createDeprecatedKey);
        Stream<FallbackKey> currentAlternativeKeys = Arrays.stream(this.fallbackKeys);
        FallbackKey[] mergedAlternativeKeys = (FallbackKey[])Stream.concat(currentAlternativeKeys, newDeprecatedKeys).toArray(FallbackKey[]::new);
        return new ConfigOption<T>(this.key, this.clazz, this.description, this.defaultValue, this.converter, mergedAlternativeKeys);
    }

    public String key() {
        return this.key;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public Iterable<FallbackKey> fallbackKeys() {
        return this.fallbackKeys == EMPTY ? Collections.emptyList() : Arrays.asList(this.fallbackKeys);
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public String description() {
        return this.description;
    }

    public T convertValue(Object v, Class<?> clazz) {
        return this.converter.apply(v);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            ConfigOption that = (ConfigOption)o;
            return this.key.equals(that.key) && (this.defaultValue == null ? that.defaultValue == null : that.defaultValue != null && this.defaultValue.equals(that.defaultValue));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.key, this.defaultValue);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s", this.key, this.defaultValue);
    }
}

