/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator.conf;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.uniffle.common.RemoteStorageInfo;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.conf.ClientConf;
import org.apache.uniffle.coordinator.conf.ClientConfParser;
import org.apache.uniffle.coordinator.util.CoordinatorUtils;
import org.apache.uniffle.guava.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyClientConfParser
implements ClientConfParser {
    private static final Logger LOG = LoggerFactory.getLogger(LegacyClientConfParser.class);
    private static final String WHITESPACE_REGEX = "\\s+";

    @Override
    public ClientConf tryParse(InputStream fileInputStream) throws Exception {
        String content = IOUtils.toString((InputStream)fileInputStream, (Charset)StandardCharsets.UTF_8);
        String remoteStoragePath = "";
        String remoteStorageConf = "";
        HashMap<String, String> rssClientConf = new HashMap<String, String>();
        for (String item : content.split("\n")) {
            String[] confKV;
            String confItem = item.trim();
            if (!StringUtils.isNotEmpty((CharSequence)confItem) || (confKV = confItem.split(WHITESPACE_REGEX)).length != 2) continue;
            if (CoordinatorConf.COORDINATOR_REMOTE_STORAGE_PATH.key().equals(confKV[0])) {
                remoteStoragePath = confKV[1];
                continue;
            }
            if (CoordinatorConf.COORDINATOR_REMOTE_STORAGE_CLUSTER_CONF.key().equals(confKV[0])) {
                remoteStorageConf = confKV[1];
                continue;
            }
            rssClientConf.put(confKV[0], confKV[1]);
        }
        Map<String, RemoteStorageInfo> storageInfoMap = this.parseRemoteStorageInfos(remoteStoragePath, remoteStorageConf);
        return new ClientConf(rssClientConf, storageInfoMap);
    }

    private Map<String, RemoteStorageInfo> parseRemoteStorageInfos(String remoteStoragePath, String remoteStorageConf) {
        if (StringUtils.isNotEmpty((CharSequence)remoteStoragePath)) {
            LOG.info("Parsing remote storage with {} {}", (Object)remoteStoragePath, (Object)remoteStorageConf);
            HashSet<String> paths = Sets.newHashSet(remoteStoragePath.split(","));
            Map<String, Map<String, String>> confKVs = CoordinatorUtils.extractRemoteStorageConf(remoteStorageConf);
            HashMap<String, RemoteStorageInfo> remoteStorageInfoMap = new HashMap<String, RemoteStorageInfo>();
            for (String path : paths) {
                try {
                    URI uri = new URI(path);
                    String host = uri.getHost();
                    Map<String, String> kvs = confKVs.get(host);
                    remoteStorageInfoMap.put(path, kvs == null ? new RemoteStorageInfo(path) : new RemoteStorageInfo(path, kvs));
                }
                catch (URISyntaxException e) {
                    LOG.warn("The remote storage path: {} is illegal. Ignore this storage", (Object)path);
                }
            }
            return remoteStorageInfoMap;
        }
        return Collections.emptyMap();
    }
}

