/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.guava.util.concurrent;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import org.apache.uniffle.guava.annotations.GwtIncompatible;
import org.apache.uniffle.guava.annotations.J2ktIncompatible;
import org.apache.uniffle.guava.util.concurrent.ElementTypesAreNonnullByDefault;
import org.apache.uniffle.guava.util.concurrent.ListenableFuture;
import org.apache.uniffle.guava.util.concurrent.ListeningExecutorService;
import org.apache.uniffle.guava.util.concurrent.ParametricNullness;
import org.apache.uniffle.guava.util.concurrent.TrustedListenableFutureTask;

@CheckReturnValue
@ElementTypesAreNonnullByDefault
@GwtIncompatible
@J2ktIncompatible
public abstract class AbstractListeningExecutorService
extends AbstractExecutorService
implements ListeningExecutorService {
    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Runnable runnable, @ParametricNullness T value) {
        return TrustedListenableFutureTask.create(runnable, value);
    }

    @Override
    @CanIgnoreReturnValue
    protected final <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return TrustedListenableFutureTask.create(callable);
    }

    @Override
    @CanIgnoreReturnValue
    public ListenableFuture<?> submit(Runnable task) {
        return (ListenableFuture)super.submit(task);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Runnable task, @ParametricNullness T result) {
        return (ListenableFuture)super.submit(task, result);
    }

    @Override
    @CanIgnoreReturnValue
    public <T> ListenableFuture<T> submit(Callable<T> task) {
        return (ListenableFuture)super.submit(task);
    }
}

