/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.uniffle.server.storage;

import java.util.Set;

import com.google.common.collect.Sets;

import org.apache.uniffle.server.ShuffleDataFlushEvent;
import org.apache.uniffle.server.ShuffleServerConf;

public class LocalStorageManagerFallbackStrategy extends AbstractStorageManagerFallbackStrategy {
  private final Long fallBackTimes;
  private Set<Class<? extends StorageManager>> excludeTypes =
      Sets.newHashSet(LocalStorageManager.class);

  public LocalStorageManagerFallbackStrategy(ShuffleServerConf conf) {
    super(conf);
    fallBackTimes = conf.get(ShuffleServerConf.FALLBACK_MAX_FAIL_TIMES);
  }

  @Override
  public StorageManager tryFallback(
      StorageManager current, ShuffleDataFlushEvent event, StorageManager... candidates) {
    if (event.getRetryTimes() > fallBackTimes || !current.canWrite(event)) {
      return findNextStorageManager(current, excludeTypes, event, candidates);
    }
    return current;
  }
}
