/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.metrics;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.metrics.EmptyGRPCMetrics;
import org.apache.uniffle.common.metrics.RPCMetrics;

public abstract class GRPCMetrics
extends RPCMetrics {
    public static final String GRPC_SERVER_EXECUTOR_ACTIVE_THREADS_KEY = "grpcServerExecutorActiveThreads";
    private static final String GRPC_SERVER_EXECUTOR_ACTIVE_THREADS = "grpc_server_executor_active_threads";
    public static final String GRPC_SERVER_EXECUTOR_BLOCKING_QUEUE_SIZE_KEY = "grpcServerExecutorBlockingQueueSize";
    private static final String GRPC_SERVER_EXECUTOR_BLOCKING_QUEUE_SIZE = "grpc_server_executor_blocking_queue_size";
    public static final String GRPC_SERVER_CONNECTION_NUMBER_KEY = "grpcServerConnectionNumber";
    private static final String GRPC_SERVER_CONNECTION_NUMBER = "grpc_server_connection_number";
    private static final String GRPC_OPEN = "grpc_open";
    private static final String GRPC_TOTAL = "grpc_total";
    protected Gauge.Child gaugeGrpcOpen;
    protected Counter.Child counterGrpcTotal;

    public GRPCMetrics(RssConf rssConf, String tags) {
        super(rssConf, tags);
    }

    @Override
    public abstract void registerMetrics();

    @Override
    public void registerGeneralMetrics() {
        this.gaugeGrpcOpen = this.metricsManager.addLabeledGauge(GRPC_OPEN);
        this.counterGrpcTotal = this.metricsManager.addLabeledCounter(GRPC_TOTAL);
        this.gaugeMap.putIfAbsent(GRPC_SERVER_EXECUTOR_ACTIVE_THREADS_KEY, this.metricsManager.addLabeledGauge(GRPC_SERVER_EXECUTOR_ACTIVE_THREADS));
        this.gaugeMap.putIfAbsent(GRPC_SERVER_EXECUTOR_BLOCKING_QUEUE_SIZE_KEY, this.metricsManager.addLabeledGauge(GRPC_SERVER_EXECUTOR_BLOCKING_QUEUE_SIZE));
        this.gaugeMap.putIfAbsent(GRPC_SERVER_CONNECTION_NUMBER_KEY, this.metricsManager.addLabeledGauge(GRPC_SERVER_CONNECTION_NUMBER));
    }

    @Override
    public void incCounter(String methodName) {
        if (this.isRegistered) {
            super.incCounter(methodName);
            this.gaugeGrpcOpen.inc();
            this.counterGrpcTotal.inc();
        }
    }

    @Override
    public void decCounter(String methodName) {
        if (this.isRegistered) {
            super.decCounter(methodName);
            this.gaugeGrpcOpen.dec();
        }
    }

    public Gauge.Child getGaugeGrpcOpen() {
        return this.gaugeGrpcOpen;
    }

    public Counter.Child getCounterGrpcTotal() {
        return this.counterGrpcTotal;
    }

    public static GRPCMetrics getEmptyGRPCMetrics(RssConf rssConf) {
        return new EmptyGRPCMetrics(rssConf, "ss_v5");
    }
}

