/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.uniffle.common.config.Reconfigurable;
import org.apache.uniffle.common.config.RssConf;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.coordinator.ClusterManager;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.QuotaManager;
import org.apache.uniffle.coordinator.access.AccessCheckResult;
import org.apache.uniffle.coordinator.access.AccessInfo;
import org.apache.uniffle.coordinator.access.checker.AccessChecker;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.shaded.guava.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessManager
implements Reconfigurable {
    private static final Logger LOG = LoggerFactory.getLogger(AccessManager.class);
    private final CoordinatorConf coordinatorConf;
    private final ClusterManager clusterManager;
    private final QuotaManager quotaManager;
    private final Configuration hadoopConf;
    private List<AccessChecker> accessCheckers = Lists.newArrayList();

    public AccessManager(CoordinatorConf conf, ClusterManager clusterManager, QuotaManager quotaManager, Configuration hadoopConf) throws Exception {
        this.coordinatorConf = conf;
        this.clusterManager = clusterManager;
        this.hadoopConf = hadoopConf;
        this.quotaManager = quotaManager;
        this.init();
    }

    private void init() {
        List checkers = (List)this.coordinatorConf.get(CoordinatorConf.COORDINATOR_ACCESS_CHECKERS);
        if (CollectionUtils.isEmpty((Collection)checkers)) {
            LOG.warn("Access checkers is empty, will not init any checkers.");
            return;
        }
        this.accessCheckers = RssUtils.loadExtensions(AccessChecker.class, (List)checkers, (Object)this);
    }

    public AccessCheckResult handleAccessRequest(AccessInfo accessInfo) {
        String uuid = "";
        CoordinatorMetrics.counterTotalAccessRequest.inc();
        for (AccessChecker checker : this.accessCheckers) {
            AccessCheckResult accessCheckResult = checker.check(accessInfo);
            if (!accessCheckResult.isSuccess()) {
                return accessCheckResult;
            }
            String resultUuid = accessCheckResult.getUuid();
            if ("".equals(resultUuid)) continue;
            uuid = resultUuid;
        }
        return new AccessCheckResult(true, "SUCCESS", uuid);
    }

    public CoordinatorConf getCoordinatorConf() {
        return this.coordinatorConf;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public List<AccessChecker> getAccessCheckers() {
        return this.accessCheckers;
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf;
    }

    public QuotaManager getQuotaManager() {
        return this.quotaManager;
    }

    public void close() throws IOException {
        for (AccessChecker checker : this.accessCheckers) {
            checker.close();
        }
    }

    public boolean isPropertyReconfigurable(String property) {
        for (AccessChecker checker : this.accessCheckers) {
            if (!(checker instanceof Reconfigurable) || !((Reconfigurable)checker).isPropertyReconfigurable(property)) continue;
            return true;
        }
        return false;
    }

    public void reconfigure(RssConf conf) {
        for (AccessChecker checker : this.accessCheckers) {
            if (!(checker instanceof Reconfigurable)) continue;
            ((Reconfigurable)checker).reconfigure(conf);
        }
    }
}

