/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.coordinator;

import io.prometheus.client.Gauge;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.uniffle.common.filesystem.HadoopFilesystemProvider;
import org.apache.uniffle.common.util.JavaUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.coordinator.CoordinatorConf;
import org.apache.uniffle.coordinator.metric.CoordinatorMetrics;
import org.apache.uniffle.shaded.guava.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaManager {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaManager.class);
    private final Map<String, Map<String, Long>> currentUserAndApp = JavaUtils.newConcurrentMap();
    private final Map<String, String> appIdToUser = JavaUtils.newConcurrentMap();
    private final String quotaFilePath;
    private final Integer quotaAppNum;
    private FileSystem hadoopFileSystem;
    private final AtomicLong quotaFileLastModify = new AtomicLong(0L);
    private final Map<String, Integer> defaultUserApps = JavaUtils.newConcurrentMap();

    public QuotaManager(CoordinatorConf conf) {
        this.quotaFilePath = (String)conf.get(CoordinatorConf.COORDINATOR_QUOTA_DEFAULT_PATH);
        this.quotaAppNum = conf.getInteger(CoordinatorConf.COORDINATOR_QUOTA_DEFAULT_APP_NUM);
        if (this.quotaFilePath == null) {
            LOG.warn("{} is not configured, each user will use the default quota : {}", (Object)CoordinatorConf.COORDINATOR_QUOTA_DEFAULT_PATH.key(), conf.get(CoordinatorConf.COORDINATOR_QUOTA_DEFAULT_APP_NUM));
        } else {
            Long updateTime = (Long)conf.get(CoordinatorConf.COORDINATOR_QUOTA_UPDATE_INTERVAL);
            try {
                this.hadoopFileSystem = HadoopFilesystemProvider.getFilesystem((Path)new Path(this.quotaFilePath), (Configuration)new Configuration());
            }
            catch (Exception e) {
                LOG.error("Cannot init remoteFS on path : {}", (Object)this.quotaFilePath, (Object)e);
            }
            ScheduledExecutorService scheduledExecutorService = ThreadUtils.getDaemonSingleThreadScheduledExecutor((String)"UpdateDefaultApp");
            scheduledExecutorService.scheduleAtFixedRate(this::detectUserResource, 0L, updateTime / 2L, TimeUnit.MILLISECONDS);
            LOG.info("QuotaManager initialized successfully.");
        }
    }

    public void detectUserResource() {
        if (this.hadoopFileSystem != null) {
            try {
                Path hadoopPath = new Path(this.quotaFilePath);
                FileStatus fileStatus = this.hadoopFileSystem.getFileStatus(hadoopPath);
                if (fileStatus != null && fileStatus.isFile()) {
                    long latestModificationTime = fileStatus.getModificationTime();
                    if (this.quotaFileLastModify.get() != latestModificationTime) {
                        this.parseQuotaFile((DataInputStream)this.hadoopFileSystem.open(hadoopPath));
                        LOG.warn("We have updated the file {}.", (Object)hadoopPath);
                        this.quotaFileLastModify.set(latestModificationTime);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                LOG.error("Can't find this file {}", (Object)this.quotaFilePath);
            }
            catch (Exception e) {
                LOG.warn("Error when updating quotaFile, the exclude nodes file path: {}", (Object)this.quotaFilePath);
            }
        }
    }

    public void parseQuotaFile(DataInputStream fsDataInputStream) {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fsDataInputStream, StandardCharsets.UTF_8));){
            String content;
            while ((content = bufferedReader.readLine()) != null) {
                if (content.startsWith("#") || content.isEmpty()) continue;
                String user = content.split("=")[0].trim();
                Integer appNum = Integer.valueOf(content.split("=")[1].trim());
                this.defaultUserApps.put(user, appNum);
            }
        }
        catch (Exception e) {
            LOG.error("Error occur when parsing file {}", (Object)this.quotaFilePath, (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkQuota(String user, String uuid) {
        Map appAndTimes = this.currentUserAndApp.computeIfAbsent(user, x -> JavaUtils.newConcurrentMap());
        Integer userAppQuotaNum = this.defaultUserApps.computeIfAbsent(user, x -> this.quotaAppNum);
        QuotaManager quotaManager = this;
        synchronized (quotaManager) {
            int currentAppNum = appAndTimes.size();
            if (userAppQuotaNum >= 0 && currentAppNum >= userAppQuotaNum) {
                return true;
            }
            appAndTimes.put(uuid, System.currentTimeMillis());
            ((Gauge.Child)CoordinatorMetrics.gaugeRunningAppNumToUser.labels(new String[]{user})).inc();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerApplicationInfo(String appId, Map<String, Long> appAndTime) {
        long currentTimeMillis = System.currentTimeMillis();
        String[] appIdAndUuid = appId.split("_");
        String uuidFromApp = appIdAndUuid[appIdAndUuid.length - 1];
        QuotaManager quotaManager = this;
        synchronized (quotaManager) {
            appAndTime.remove(uuidFromApp);
            appAndTime.put(appId, currentTimeMillis);
        }
    }

    protected void updateQuotaMetrics() {
        for (Map.Entry<String, Map<String, Long>> userAndApp : this.currentUserAndApp.entrySet()) {
            String user = userAndApp.getKey();
            try {
                ((Gauge.Child)CoordinatorMetrics.gaugeRunningAppNumToUser.labels(new String[]{user})).set((double)userAndApp.getValue().size());
            }
            catch (Exception e) {
                LOG.warn("Update user metrics for {} failed ", (Object)user, (Object)e);
            }
        }
    }

    @VisibleForTesting
    public Map<String, Integer> getDefaultUserApps() {
        return this.defaultUserApps;
    }

    public Map<String, Map<String, Long>> getCurrentUserAndApp() {
        return this.currentUserAndApp;
    }

    public Map<String, String> getAppIdToUser() {
        return this.appIdToUser;
    }
}

