/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.cdi;

import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.cdi.ConversationIdMetaKey;
import org.apache.wicket.cdi.INonContextualManager;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.lang.Args;
import org.jboss.seam.conversation.spi.SeamConversationContext;
import org.jboss.seam.conversation.spi.SeamConversationContextFactory;

public class CdiContainer {
    private static final MetaDataKey<CdiContainer> CONTEXT_KEY = new MetaDataKey<CdiContainer>(){
        private static final long serialVersionUID = 1L;
    };
    protected final BeanManager beanManager;
    private final SeamConversationContext<HttpServletRequest> conversationContext;
    private final INonContextualManager nonContextualManager;

    public CdiContainer(BeanManager beanManager, INonContextualManager nonContextualManager) {
        Args.notNull((Object)beanManager, (String)"beanManager");
        Args.notNull((Object)nonContextualManager, (String)"nonContextualManager");
        this.beanManager = beanManager;
        this.nonContextualManager = nonContextualManager;
        this.conversationContext = SeamConversationContextFactory.getContext(HttpServletRequest.class);
        if (this.conversationContext == null) {
            throw new IllegalStateException("Could not resolve conversation context manager. Make sure a Seam-Conversation module for your CDI container implementation is included in your dependencies.");
        }
    }

    public INonContextualManager getNonContextualManager() {
        return this.nonContextualManager;
    }

    public void deactivateConversationalContext(RequestCycle cycle) {
        this.conversationContext.deactivate();
        this.conversationContext.dissociate((Object)this.getRequest(cycle));
    }

    public void activateConversationalContext(RequestCycle cycle, String cid) {
        this.conversationContext.associate((Object)this.getRequest(cycle));
        this.conversationContext.activate(cid);
    }

    private HttpServletRequest getRequest(RequestCycle cycle) {
        return (HttpServletRequest)cycle.getRequest().getContainerRequest();
    }

    public String getConversationMarker(Page page) {
        return (String)((Object)page.getMetaData((MetaDataKey)ConversationIdMetaKey.INSTANCE));
    }

    public void removeConversationMarker(Page page) {
        Args.notNull((Object)page, (String)"page");
        page.setMetaData((MetaDataKey)ConversationIdMetaKey.INSTANCE, null);
        page.getPageParameters().remove("cid", new String[0]);
    }

    protected void bind(Application application) {
        application.setMetaData(CONTEXT_KEY, (Object)this);
    }

    public static final CdiContainer get(Application application) {
        CdiContainer ctx = (CdiContainer)application.getMetaData(CONTEXT_KEY);
        if (ctx == null) {
            throw new IllegalStateException("No CDI Context bound to application");
        }
        return ctx;
    }

    public static final CdiContainer get() {
        return CdiContainer.get(Application.get());
    }
}

