/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.wicket.Application;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.DefaultMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupCache;
import org.apache.wicket.markup.IMarkupCacheKeyProvider;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.MarkupFactory;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.listener.IChangeListener;
import org.apache.wicket.util.watch.IModifiable;
import org.apache.wicket.util.watch.IModificationWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkupCache
implements IMarkupCache {
    private static final Logger log = LoggerFactory.getLogger(MarkupCache.class);
    private final ICache<String, Markup> markupCache;
    private final ICache<String, String> markupKeyCache;
    private IMarkupCacheKeyProvider markupCacheKeyProvider;
    private final Application application = Application.get();

    public static IMarkupCache get() {
        return Application.get().getMarkupSettings().getMarkupFactory().getMarkupCache();
    }

    protected MarkupCache() {
        this.markupCache = this.newCacheImplementation();
        if (this.markupCache == null) {
            throw new WicketRuntimeException("The map used to cache markup must not be null");
        }
        this.markupKeyCache = this.newCacheImplementation();
    }

    @Override
    public void clear() {
        this.markupCache.clear();
        this.markupKeyCache.clear();
    }

    @Override
    public void shutdown() {
        this.markupCache.shutdown();
        this.markupKeyCache.shutdown();
    }

    @Override
    public final IMarkupFragment removeMarkup(String cacheKey) {
        String locationString;
        IMarkupFragment markup;
        Args.notNull((Object)cacheKey, (String)"cacheKey");
        if (log.isDebugEnabled()) {
            log.debug("Removing from cache: " + cacheKey);
        }
        IMarkupFragment iMarkupFragment = markup = (locationString = this.markupKeyCache.get(cacheKey)) != null ? (IMarkupFragment)this.markupCache.get(locationString) : null;
        if (markup == null) {
            return null;
        }
        this.markupCache.remove(locationString);
        if (log.isDebugEnabled()) {
            log.debug("Removed from cache: " + locationString);
        }
        this.removeMarkupWhereBaseMarkupIsNoLongerInTheCache();
        IModificationWatcher watcher = this.application.getResourceSettings().getResourceWatcher(false);
        if (watcher != null) {
            Iterator iter = watcher.getEntries().iterator();
            while (iter.hasNext()) {
                IModifiable modifiable = (IModifiable)iter.next();
                if (!(modifiable instanceof MarkupResourceStream) || this.isMarkupCached((MarkupResourceStream)modifiable)) continue;
                iter.remove();
                if (!log.isDebugEnabled()) continue;
                log.debug("Removed from watcher: " + modifiable);
            }
        }
        return markup;
    }

    private void removeMarkupWhereBaseMarkupIsNoLongerInTheCache() {
        int count = 1;
        while (count > 0) {
            count = 0;
            Iterator<Markup> iter = this.markupCache.getValues().iterator();
            while (iter.hasNext()) {
                Markup markup = iter.next();
                if (markup == null || markup == Markup.NO_MARKUP) continue;
                MarkupResourceStream resourceStream = markup.getMarkupResourceStream();
                if (resourceStream != null) {
                    resourceStream = resourceStream.getBaseMarkupResourceStream();
                }
                if (resourceStream == null || this.isMarkupCached(resourceStream)) continue;
                iter.remove();
                ++count;
                if (!log.isDebugEnabled()) continue;
                log.debug("Removed derived markup from cache: " + markup.getMarkupResourceStream());
            }
        }
    }

    private boolean isMarkupCached(MarkupResourceStream resourceStream) {
        String locationString;
        String key;
        return resourceStream != null && (key = resourceStream.getCacheKey()) != null && (locationString = this.markupKeyCache.get(key)) != null && this.markupCache.get(locationString) != null;
    }

    @Override
    public final int size() {
        return this.markupCache.size();
    }

    public final ICache<String, Markup> getMarkupCache() {
        return this.markupCache;
    }

    @Override
    public final Markup getMarkup(MarkupContainer container, Class<?> clazz, boolean enforceReload) {
        Class<?> containerClass = MarkupFactory.get().getContainerClass(container, clazz);
        String cacheKey = this.getMarkupCacheKeyProvider(container).getCacheKey(container, containerClass);
        Markup markup = null;
        if (!enforceReload && cacheKey != null) {
            markup = this.getMarkupFromCache(cacheKey, container);
        }
        if (markup == null) {
            MarkupResourceStream resourceStream;
            if (log.isDebugEnabled()) {
                log.debug("Load markup: cacheKey=" + cacheKey);
            }
            if ((resourceStream = MarkupFactory.get().getMarkupResourceStream(container, containerClass)) != null) {
                resourceStream.setCacheKey(cacheKey);
                markup = this.loadMarkupAndWatchForChanges(container, resourceStream, enforceReload);
            } else {
                markup = this.onMarkupNotFound(cacheKey, container, Markup.NO_MARKUP);
            }
        }
        if (markup == Markup.NO_MARKUP) {
            markup = null;
        }
        return markup;
    }

    protected Markup onMarkupNotFound(String cacheKey, MarkupContainer container, Markup markup) {
        if (log.isDebugEnabled()) {
            log.debug("Markup not found: " + cacheKey);
        }
        if (cacheKey != null) {
            this.markupKeyCache.put(cacheKey, cacheKey);
            this.putIntoCache(cacheKey, container, markup);
        }
        return markup;
    }

    protected Markup putIntoCache(String locationString, MarkupContainer container, Markup markup) {
        if (locationString != null) {
            if (!this.markupCache.containsKey(locationString)) {
                if (markup == null) {
                    markup = Markup.NO_MARKUP;
                }
                this.markupCache.put(locationString, markup);
            } else {
                markup = this.markupCache.get(locationString);
            }
        }
        return markup;
    }

    protected Markup getMarkupFromCache(String cacheKey, MarkupContainer container) {
        String locationString;
        if (cacheKey != null && (locationString = this.markupKeyCache.get(cacheKey)) != null) {
            return this.markupCache.get(locationString);
        }
        return null;
    }

    private Markup loadMarkup(MarkupContainer container, MarkupResourceStream markupResourceStream, boolean enforceReload) {
        Markup markup;
        String cacheKey = markupResourceStream.getCacheKey();
        String locationString = markupResourceStream.locationAsString();
        if (locationString == null) {
            locationString = cacheKey;
        }
        if ((markup = MarkupFactory.get().loadMarkup(container, markupResourceStream, enforceReload)) != null) {
            if (cacheKey != null) {
                String temp = markup.locationAsString();
                if (temp != null) {
                    locationString = temp;
                }
                this.markupKeyCache.put(cacheKey, locationString);
                return this.putIntoCache(locationString, container, markup);
            }
            return markup;
        }
        if (cacheKey != null) {
            this.removeMarkup(cacheKey);
        }
        return Markup.NO_MARKUP;
    }

    private Markup loadMarkupAndWatchForChanges(MarkupContainer container, final MarkupResourceStream markupResourceStream, boolean enforceReload) {
        final String cacheKey = markupResourceStream.getCacheKey();
        if (cacheKey != null) {
            IModificationWatcher watcher;
            if (!enforceReload) {
                Markup markup;
                String locationString = markupResourceStream.locationAsString();
                if (locationString == null) {
                    locationString = cacheKey;
                }
                if ((markup = this.markupCache.get(locationString)) != null) {
                    this.markupKeyCache.put(cacheKey, locationString);
                    return markup;
                }
            }
            if ((watcher = this.application.getResourceSettings().getResourceWatcher(true)) != null) {
                watcher.add((IModifiable)markupResourceStream, (IChangeListener)new IChangeListener<IModifiable>(){

                    public void onChange(IModifiable modifiable) {
                        if (log.isDebugEnabled()) {
                            log.debug("Remove markup from watcher: " + markupResourceStream);
                        }
                        watcher.remove((IModifiable)markupResourceStream);
                        MarkupCache.this.removeMarkup(cacheKey);
                    }
                });
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Loading markup from " + markupResourceStream);
        }
        return this.loadMarkup(container, markupResourceStream, enforceReload);
    }

    public IMarkupCacheKeyProvider getMarkupCacheKeyProvider(MarkupContainer container) {
        if (container instanceof IMarkupCacheKeyProvider) {
            return (IMarkupCacheKeyProvider)((Object)container);
        }
        if (this.markupCacheKeyProvider == null) {
            this.markupCacheKeyProvider = new DefaultMarkupCacheKeyProvider();
        }
        return this.markupCacheKeyProvider;
    }

    protected <K, V> ICache<K, V> newCacheImplementation() {
        return new DefaultCacheImplementation();
    }

    public static class DefaultCacheImplementation<K, V>
    implements ICache<K, V> {
        private final ConcurrentHashMap<K, V> cache = new ConcurrentHashMap();

        @Override
        public void clear() {
            this.cache.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                return false;
            }
            return this.cache.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                return null;
            }
            return this.cache.get(key);
        }

        @Override
        public Collection<K> getKeys() {
            return this.cache.keySet();
        }

        @Override
        public Collection<V> getValues() {
            return this.cache.values();
        }

        @Override
        public void put(K key, V value) {
            this.cache.put(key, value);
        }

        @Override
        public boolean remove(K key) {
            if (key == null) {
                return false;
            }
            return this.cache.remove(key) == null;
        }

        @Override
        public int size() {
            return this.cache.size();
        }

        @Override
        public void shutdown() {
            this.clear();
        }
    }

    public static interface ICache<K, V> {
        public void clear();

        public boolean remove(K var1);

        public V get(K var1);

        public Collection<K> getKeys();

        public Collection<V> getValues();

        public boolean containsKey(K var1);

        public int size();

        public void put(K var1, V var2);

        public void shutdown();
    }
}

