/*
 * Decompiled with CFR 0.152.
 */
package dr.math;

public class SparseMatrixExponential {
    public static int maxKrylovBasisSize = 50;
    public static double tolerance = 1.0E-7;
    private int order;
    private int nonZeroEntries;
    private int krylovBasisSize;
    private double[] workSpace;
    private int[] intWorkSpace;
    private int lengthWorkspace;
    private int lengthIntWorkspace;
    private int[] fortranIndexX;
    private int[] fortranIndexY;
    private double[] rate;
    private double[] start;
    private double[] stop;
    private double norm;
    int index = 0;

    private native void executeDGEXPV(int var1, int var2, int var3, double var4, double[] var6, double[] var7, double var8, double var10, double[] var12, int[] var13, int[] var14, double[] var15, int var16, int[] var17, int var18, int var19);

    public SparseMatrixExponential(int n, int n2) {
        this.order = n;
        this.nonZeroEntries = n2;
        this.setUpWorkspace();
    }

    private void setUpWorkspace() {
        this.krylovBasisSize = this.order < maxKrylovBasisSize ? this.order - 10 : maxKrylovBasisSize - 1;
        this.lengthIntWorkspace = this.krylovBasisSize + 2;
        this.lengthWorkspace = this.order * this.lengthIntWorkspace + 5 * this.lengthIntWorkspace * this.lengthIntWorkspace + 7;
        this.intWorkSpace = new int[this.lengthIntWorkspace];
        this.workSpace = new double[this.lengthWorkspace];
        this.start = new double[this.order];
        this.stop = new double[this.order];
        this.fortranIndexX = new int[this.nonZeroEntries];
        this.fortranIndexY = new int[this.nonZeroEntries];
        this.rate = new double[this.nonZeroEntries];
    }

    public void addEntry(int n, int n2, double d) {
        this.fortranIndexX[this.index] = n + 1;
        this.fortranIndexY[this.index] = n2 + 1;
        this.rate[this.index] = d;
        ++this.index;
    }

    public void setNorm(double d) {
        this.norm = d;
    }

    public void calculateInfinityNorm() {
    }

    public double getExponentialEntry(int n, int n2, double d) {
        this.start[n] = 1.0;
        int n3 = 0;
        this.executeDGEXPV(this.order, this.nonZeroEntries, this.krylovBasisSize, d, this.start, this.stop, tolerance, this.norm, this.rate, this.fortranIndexX, this.fortranIndexY, this.workSpace, this.lengthWorkspace, this.intWorkSpace, this.lengthIntWorkspace, n3);
        this.start[n] = 0.0;
        return this.stop[n2];
    }

    public String sparseRepresentation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.order + " " + this.nonZeroEntries + "\n");
        for (int i = 0; i < this.nonZeroEntries; ++i) {
            stringBuffer.append(this.fortranIndexX[i]);
            stringBuffer.append(" ");
            stringBuffer.append(this.fortranIndexY[i]);
            stringBuffer.append(" ");
            stringBuffer.append(this.rate[i]);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    static {
        System.loadLibrary("ExpoKit");
    }
}

