/*
 * Decompiled with CFR 0.152.
 */
package dr.math.distributions;

import dr.inference.distribution.RandomField;
import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.GradientProvider;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.Distribution;
import dr.math.distributions.RandomFieldDistribution;

public class BaselineIncrementField
extends RandomFieldDistribution
implements BayesianBridgeStatisticsProvider {
    public static final String TYPE = "BaselineIncrementField";
    private final Distribution baseline;
    private final Distribution increments;
    private final GradientProvider baselineGradient;
    private final GradientProvider incrementGradient;
    private final BayesianBridgeStatisticsProvider bayesianBridge;

    public BaselineIncrementField(String string, Distribution distribution, Distribution distribution2, RandomField.WeightProvider weightProvider) {
        super(string);
        this.baseline = distribution;
        this.increments = distribution2;
        if (distribution instanceof Model) {
            this.addModel((Model)((Object)distribution));
        }
        if (distribution2 instanceof Model) {
            this.addModel((Model)((Object)distribution2));
        }
        this.baselineGradient = distribution instanceof GradientProvider ? (GradientProvider)((Object)distribution) : null;
        this.incrementGradient = distribution2 instanceof GradientProvider ? (GradientProvider)((Object)distribution2) : null;
        BayesianBridgeStatisticsProvider bayesianBridgeStatisticsProvider = this.bayesianBridge = distribution2 instanceof BayesianBridgeStatisticsProvider ? (BayesianBridgeStatisticsProvider)((Object)distribution) : null;
        if (weightProvider != null) {
            throw new IllegalArgumentException("Unsure how weights influence this field");
        }
    }

    @Override
    public Variable<Double> getLocationVariable() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] nextRandom() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        throw new IllegalArgumentException("Unknown variable");
    }

    @Override
    public double getCoefficient(int n) {
        throw new RuntimeException("Should not be called");
    }

    @Override
    public Parameter getGlobalScale() {
        if (this.bayesianBridge != null) {
            return this.bayesianBridge.getGlobalScale();
        }
        throw new IllegalArgumentException("Not a Bayesian bridge");
    }

    @Override
    public Parameter getLocalScale() {
        if (this.bayesianBridge != null) {
            return this.bayesianBridge.getLocalScale();
        }
        throw new IllegalArgumentException("Not a Bayesian bridge");
    }

    @Override
    public Parameter getExponent() {
        if (this.bayesianBridge != null) {
            return this.bayesianBridge.getExponent();
        }
        throw new IllegalArgumentException("Not a Bayesian bridge");
    }

    @Override
    public Parameter getSlabWidth() {
        if (this.bayesianBridge != null) {
            return this.bayesianBridge.getSlabWidth();
        }
        throw new IllegalArgumentException("Not a Bayesian bridge");
    }

    @Override
    public int getDimension() {
        if (this.bayesianBridge != null) {
            return this.bayesianBridge.getDimension();
        }
        throw new IllegalArgumentException("Not a Bayesian bridge");
    }

    @Override
    public double[] getGradientLogDensity(Object object) {
        double[] dArray = (double[])object;
        double[] dArray2 = new double[dArray.length - 1];
        System.arraycopy(dArray, 1, dArray2, 0, dArray.length - 1);
        double[] dArray3 = this.baselineGradient.getGradientLogDensity(new double[]{dArray[0]});
        double[] dArray4 = this.incrementGradient.getGradientLogDensity(dArray2);
        double[] dArray5 = new double[dArray.length];
        dArray5[0] = dArray3[0];
        System.arraycopy(dArray4, 0, dArray5, 1, dArray.length - 1);
        return dArray5;
    }

    @Override
    public double[] getDiagonalHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[][] getHessianLogDensity(Object object) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double logPdf(double[] dArray) {
        double d = this.baseline.logPdf(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            d += this.increments.logPdf(dArray[i]);
        }
        return d;
    }

    @Override
    public double[][] getScaleMatrix() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double[] getMean() {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public GradientProvider getGradientWrt(Parameter parameter) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    public double getIncrement(int n, Parameter parameter) {
        return parameter.getParameterValue(n + 1);
    }
}

